/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.augmenter;

import com.mojang.serialization.Codec;
import io.wispforest.owo.network.ClientAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBlockTags;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import rearth.oritech.Oritech;
import rearth.oritech.client.other.OreFinderRenderer;
import rearth.oritech.init.EntitiesContent;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.PortalEntity;

public class PlayerAugments {
    public static final Map<ResourceLocation, PlayerAugment> allAugments = new HashMap<ResourceLocation, PlayerAugment>();
    private static final PlayerAugment hpBoost = new PlayerStatEnhancingAugment(Oritech.id("hpboost"), (Holder<Attribute>)Attributes.MAX_HEALTH, 6.0f, AttributeModifier.Operation.ADD_VALUE);
    private static final PlayerAugment hpBoostMore = new PlayerStatEnhancingAugment(Oritech.id("hpboostmore"), (Holder<Attribute>)Attributes.MAX_HEALTH, 4.0f, AttributeModifier.Operation.ADD_VALUE);
    private static final PlayerAugment hpBoostUltra = new PlayerStatEnhancingAugment(Oritech.id("hpboostultra"), (Holder<Attribute>)Attributes.MAX_HEALTH, 10.0f, AttributeModifier.Operation.ADD_VALUE);
    private static final PlayerAugment hpBoostUltimate = new PlayerStatEnhancingAugment(Oritech.id("hpboostultimate"), (Holder<Attribute>)Attributes.MAX_HEALTH, 10.0f, AttributeModifier.Operation.ADD_VALUE);
    private static final PlayerAugment speedBoost = new PlayerStatEnhancingAugment(Oritech.id("speedboost"), (Holder<Attribute>)Attributes.MOVEMENT_SPEED, 0.25f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, false);
    private static final PlayerAugment superSpeedBoost = new PlayerStatEnhancingAugment(Oritech.id("superspeedboost"), (Holder<Attribute>)Attributes.MOVEMENT_SPEED, 0.25f, AttributeModifier.Operation.ADD_VALUE, true);
    private static final PlayerAugment stepAssist = new PlayerStatEnhancingAugment(Oritech.id("stepassist"), (Holder<Attribute>)Attributes.STEP_HEIGHT, 0.6f, AttributeModifier.Operation.ADD_VALUE, true);
    private static final PlayerAugment dwarf = new PlayerStatEnhancingAugment(Oritech.id("dwarf"), (Holder<Attribute>)Attributes.SCALE, -0.5f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, false);
    private static final PlayerAugment giant = new PlayerStatEnhancingAugment(Oritech.id("giant"), (Holder<Attribute>)Attributes.SCALE, 1.0f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, true);
    private static final PlayerAugment armor = new PlayerStatEnhancingAugment(Oritech.id("armor"), (Holder<Attribute>)Attributes.ARMOR, 4.0f, AttributeModifier.Operation.ADD_VALUE);
    private static final PlayerAugment betterArmor = new PlayerStatEnhancingAugment(Oritech.id("betterarmor"), (Holder<Attribute>)Attributes.ARMOR, 6.0f, AttributeModifier.Operation.ADD_VALUE);
    private static final PlayerAugment ultimateArmor = new PlayerStatEnhancingAugment(Oritech.id("ultimatearmor"), (Holder<Attribute>)Attributes.ARMOR, 8.0f, AttributeModifier.Operation.ADD_VALUE);
    private static final PlayerAugment weaponReach = new PlayerStatEnhancingAugment(Oritech.id("weaponreach"), (Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE, 0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final PlayerAugment blockReach = new PlayerStatEnhancingAugment(Oritech.id("blockreach"), (Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE, 0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final PlayerAugment farBlockReach = new PlayerStatEnhancingAugment(Oritech.id("farblockreach"), (Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE, 1.0f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, true);
    private static final PlayerAugment miningSpeed = new PlayerStatEnhancingAugment(Oritech.id("miningspeed"), (Holder<Attribute>)Attributes.BLOCK_BREAK_SPEED, 0.5f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, false);
    private static final PlayerAugment superMiningSpeed = new PlayerStatEnhancingAugment(Oritech.id("superminingspeed"), (Holder<Attribute>)Attributes.BLOCK_BREAK_SPEED, 3.0f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, true);
    private static final PlayerAugment luck = new PlayerStatEnhancingAugment(Oritech.id("luck"), (Holder<Attribute>)Attributes.LUCK, 500.0f, AttributeModifier.Operation.ADD_VALUE, false);
    private static final PlayerAugment gravity = new PlayerStatEnhancingAugment(Oritech.id("gravity"), (Holder<Attribute>)Attributes.GRAVITY, -0.5f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, false);
    private static final PlayerAugment attackDamage = new PlayerStatEnhancingAugment(Oritech.id("attackdamage"), (Holder<Attribute>)Attributes.ATTACK_DAMAGE, 4.0f, AttributeModifier.Operation.ADD_VALUE, false, true);
    private static final PlayerAugment superAttackDamage = new PlayerStatEnhancingAugment(Oritech.id("superattackdamage"), (Holder<Attribute>)Attributes.ATTACK_DAMAGE, 6.0f, AttributeModifier.Operation.ADD_VALUE, false, true);
    private static final PlayerAugment flight = new PlayerCustomAugment(Oritech.id("flight"), true){

        @Override
        public void onInstalled(Player player) {
            player.getAbilities().mayfly = true;
            player.onUpdateAbilities();
            if (this.autoSync && !player.level().isClientSide) {
                NetworkContent.MACHINE_CHANNEL.serverHandle(player).send((Record)new NetworkContent.AugmentOperationSyncPacket(this.id, AugmentOperation.ADD.ordinal()));
            }
        }

        @Override
        public void onRemoved(Player player) {
            player.getAbilities().mayfly = false;
            player.getAbilities().flying = false;
            player.onUpdateAbilities();
        }

        @Override
        public void onPlayerLoad(Player player) {
            this.onInstalled(player);
        }

        @Override
        public void toggle(Player player) {
            boolean bl = player.getAbilities().mayfly = !player.getAbilities().mayfly;
            if (!player.getAbilities().mayfly && player.getAbilities().flying) {
                player.getAbilities().flying = false;
            }
            player.onUpdateAbilities();
        }

        @Override
        public boolean isEnabled(Player player) {
            return player.getAbilities().mayfly;
        }
    };
    private static final PlayerAugment cloak = new PlayerCustomAugment(Oritech.id("cloak"), true){

        @Override
        public void onInstalled(Player player) {
            player.setInvisible(true);
        }

        @Override
        public void onRemoved(Player player) {
            player.setInvisible(false);
        }

        @Override
        public void onPlayerLoad(Player player) {
            this.onInstalled(player);
            if (this.autoSync && !player.level().isClientSide) {
                NetworkContent.MACHINE_CHANNEL.serverHandle(player).send((Record)new NetworkContent.AugmentOperationSyncPacket(this.id, AugmentOperation.ADD.ordinal()));
            }
        }

        @Override
        public void toggle(Player player) {
            super.toggle(player);
            boolean isInvisible = player.isInvisible();
            player.setInvisible(!isInvisible);
        }

        @Override
        public boolean isEnabled(Player player) {
            return player.isInvisible();
        }
    };
    public static final PlayerAugment portal = new PlayerPortalAugment(Oritech.id("portal"), true);
    public static final PlayerAugment nightVision = new PlayerCustomAugment(Oritech.id("nightvision"), true){

        @Override
        public void onInstalled(Player player) {
            player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 999999, 0, true, false, false));
        }

        @Override
        public void onRemoved(Player player) {
            player.removeEffect(MobEffects.NIGHT_VISION);
        }

        @Override
        public void toggle(Player player) {
            if (player.hasEffect(MobEffects.NIGHT_VISION)) {
                this.onRemoved(player);
            } else {
                this.onInstalled(player);
            }
        }

        @Override
        public boolean isEnabled(Player player) {
            return player.hasEffect(MobEffects.NIGHT_VISION);
        }
    };
    public static final PlayerAugment waterBreathing = new PlayerCustomAugment(Oritech.id("waterbreath")){

        @Override
        public void onInstalled(Player player) {
            player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 999999, 0, true, false, false));
        }

        @Override
        public void onRemoved(Player player) {
            player.removeEffect(MobEffects.WATER_BREATHING);
        }

        @Override
        public void toggle(Player player) {
            if (player.hasEffect(MobEffects.WATER_BREATHING)) {
                this.onRemoved(player);
            } else {
                this.onInstalled(player);
            }
        }

        @Override
        public boolean isEnabled(Player player) {
            return player.hasEffect(MobEffects.WATER_BREATHING);
        }
    };
    public static final PlayerAugment autoFeeder = new PlayerTickingAugment(Oritech.id("autofeeder"), true){

        @Override
        public void serverTick(Player player) {
            int playerHungerCapacity = 20 - player.getFoodData().getFoodLevel();
            if (playerHungerCapacity < 2) {
                return;
            }
            Integer storedFood = (Integer)player.getAttached(this.getOwnType());
            if (storedFood == null) {
                return;
            }
            if (storedFood > 0) {
                int usedFood = Math.min(playerHungerCapacity, storedFood);
                player.getFoodData().eat(usedFood, 1.0f);
                player.setAttached(this.getOwnType(), (Object)(storedFood - usedFood));
            } else {
                Optional<ItemStack> foodCandidate = player.getInventory().items.stream().filter(item -> item.has(DataComponents.FOOD)).findFirst();
                if (foodCandidate.isPresent()) {
                    ItemStack foodSourceStack = foodCandidate.get();
                    int gainedFood = Objects.requireNonNull((FoodProperties)foodSourceStack.get(DataComponents.FOOD)).nutrition();
                    foodSourceStack.shrink(1);
                    player.setAttached(this.getOwnType(), (Object)gainedFood);
                }
            }
        }

        @Override
        public void toggle(Player player) {
            super.toggle(player);
            Integer value = (Integer)player.getAttached(this.getOwnType());
            if (value == null) {
                return;
            }
            if (value >= 0) {
                player.setAttached(this.getOwnType(), (Object)-1);
            } else {
                player.setAttached(this.getOwnType(), (Object)0);
            }
        }

        @Override
        public boolean isEnabled(Player player) {
            Integer value = (Integer)player.getAttached(this.getOwnType());
            return value != null && value >= 0;
        }
    };
    public static final PlayerAugment magnet = new PlayerTickingAugment(Oritech.id("magnet"), true){

        @Override
        public void serverTick(Player player) {
            Level world = player.level();
            Vec3 target = player.getEyePosition();
            if (world.getGameTime() % 2L == 0L) {
                return;
            }
            int range = 8;
            double speed = 0.3;
            AABB box = new AABB(target.x - (double)range, target.y - (double)range, target.z - (double)range, target.x + (double)range, target.y + (double)range, target.z + (double)range);
            List items = world.getEntitiesOfClass(ItemEntity.class, box, itemEntity -> !itemEntity.hasPickUpDelay());
            for (ItemEntity item : items) {
                Vec3 direction = target.subtract(item.position()).normalize().scale(speed);
                item.push(direction);
            }
        }

        @Override
        public void toggle(Player player) {
            super.toggle(player);
            Integer value = (Integer)player.getAttached(this.getOwnType());
            if (value == null) {
                return;
            }
            if (value >= 0) {
                player.setAttached(this.getOwnType(), (Object)-1);
            } else {
                player.setAttached(this.getOwnType(), (Object)0);
            }
        }

        @Override
        public boolean isEnabled(Player player) {
            Integer value = (Integer)player.getAttached(this.getOwnType());
            return value != null && value >= 0;
        }
    };
    public static final PlayerAugment oreFinder = new PlayerTickingAugment(Oritech.id("orefinder"), true){

        @Override
        public void serverTick(Player player) {
        }

        @Override
        public void clientTick(Player player) {
            Level world = player.level();
            BlockPos target = BlockPos.containing((Position)player.getEyePosition());
            if (world.getGameTime() % 20L != 0L) {
                return;
            }
            int range = 16;
            ArrayList<BlockPos> highlightPositions = new ArrayList<BlockPos>();
            BlockPos.betweenClosed((int)(target.getX() - range), (int)(target.getY() - range), (int)(target.getZ() - range), (int)(target.getX() + range), (int)(target.getY() + range), (int)(target.getZ() + range)).forEach(pos -> {
                BlockState state = world.getBlockState(pos);
                boolean isOre = state.is(ConventionalBlockTags.ORES);
                if (isOre) {
                    highlightPositions.add(pos.immutable());
                }
            });
            if (!highlightPositions.isEmpty()) {
                OreFinderRenderer.receivedAt = player.level().getGameTime();
                OreFinderRenderer.renderedBlocks = highlightPositions;
            }
        }

        @Override
        public void toggle(Player player) {
            super.toggle(player);
            Integer value = (Integer)player.getAttached(this.getOwnType());
            if (value == null) {
                return;
            }
            if (value >= 0) {
                player.setAttached(this.getOwnType(), (Object)-1);
            } else {
                player.setAttached(this.getOwnType(), (Object)0);
            }
        }

        @Override
        public boolean isEnabled(Player player) {
            Integer value = (Integer)player.getAttached(this.getOwnType());
            return value != null && value >= 0;
        }
    };

    public static void init() {
        PlayerAugments.addAugmentAsset(hpBoost);
        PlayerAugments.addAugmentAsset(hpBoostMore);
        PlayerAugments.addAugmentAsset(hpBoostUltra);
        PlayerAugments.addAugmentAsset(hpBoostUltimate);
        PlayerAugments.addAugmentAsset(speedBoost);
        PlayerAugments.addAugmentAsset(superSpeedBoost);
        PlayerAugments.addAugmentAsset(stepAssist);
        PlayerAugments.addAugmentAsset(dwarf);
        PlayerAugments.addAugmentAsset(giant);
        PlayerAugments.addAugmentAsset(autoFeeder);
        PlayerAugments.addAugmentAsset(armor);
        PlayerAugments.addAugmentAsset(betterArmor);
        PlayerAugments.addAugmentAsset(ultimateArmor);
        PlayerAugments.addAugmentAsset(flight);
        PlayerAugments.addAugmentAsset(cloak);
        PlayerAugments.addAugmentAsset(portal);
        PlayerAugments.addAugmentAsset(nightVision);
        PlayerAugments.addAugmentAsset(weaponReach);
        PlayerAugments.addAugmentAsset(blockReach);
        PlayerAugments.addAugmentAsset(farBlockReach);
        PlayerAugments.addAugmentAsset(miningSpeed);
        PlayerAugments.addAugmentAsset(superMiningSpeed);
        PlayerAugments.addAugmentAsset(attackDamage);
        PlayerAugments.addAugmentAsset(superAttackDamage);
        PlayerAugments.addAugmentAsset(luck);
        PlayerAugments.addAugmentAsset(gravity);
        PlayerAugments.addAugmentAsset(waterBreathing);
        PlayerAugments.addAugmentAsset(magnet);
        PlayerAugments.addAugmentAsset(oreFinder);
    }

    private static void addAugmentAsset(PlayerAugment augment) {
        allAugments.put(augment.id, augment);
        augment.register();
    }

    public static void refreshPlayerAugments(Player player) {
        for (PlayerAugment augment : allAugments.values()) {
            if (!augment.isInstalled(player)) continue;
            augment.onPlayerLoad(player);
        }
    }

    public static void serverTickAugments(Player player) {
        for (PlayerAugment augment : allAugments.values()) {
            if (!(augment instanceof TickingAugment)) continue;
            TickingAugment tickingAugment = (TickingAugment)((Object)augment);
            if (!augment.isInstalled(player) || !augment.isEnabled(player)) continue;
            tickingAugment.serverTick(player);
        }
    }

    public static void clientTickAugments(Player player) {
        for (PlayerAugment augment : allAugments.values()) {
            if (!(augment instanceof TickingAugment)) continue;
            TickingAugment tickingAugment = (TickingAugment)((Object)augment);
            if (!augment.isInstalled(player) || !augment.isEnabled(player)) continue;
            tickingAugment.clientTick(player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handlePlayerAugmentOperation(NetworkContent.AugmentOperationSyncPacket message, ClientAccess access) {
        LocalPlayer player = access.player();
        PlayerAugment augmentInstance = allAugments.get(message.id());
        if (message.operation() == AugmentOperation.ADD.ordinal()) {
            augmentInstance.installToPlayer((Player)player);
        } else if (message.operation() == AugmentOperation.REMOVE.ordinal()) {
            augmentInstance.removeFromPlayer((Player)player);
        } else if (message.operation() == AugmentOperation.TOGGLE.ordinal()) {
            augmentInstance.toggle((Player)player);
        }
    }

    public static abstract class PlayerAugment {
        public final ResourceLocation id;
        public final boolean toggleable;
        public final boolean autoSync;

        protected PlayerAugment(ResourceLocation id, boolean toggleable, boolean autoSync) {
            this.id = id;
            this.toggleable = toggleable;
            this.autoSync = autoSync;
        }

        public abstract boolean isInstalled(Player var1);

        public abstract void installToPlayer(Player var1);

        public abstract void removeFromPlayer(Player var1);

        public void onInstalled(Player player) {
        }

        public void onRemoved(Player player) {
        }

        public void onPlayerLoad(Player player) {
            if (this.autoSync && !player.level().isClientSide) {
                NetworkContent.MACHINE_CHANNEL.serverHandle(player).send((Record)new NetworkContent.AugmentOperationSyncPacket(this.id, AugmentOperation.ADD.ordinal()));
                if (this.toggleable && !this.isEnabled(player)) {
                    NetworkContent.MACHINE_CHANNEL.serverHandle(player).send((Record)new NetworkContent.AugmentOperationSyncPacket(this.id, AugmentOperation.TOGGLE.ordinal()));
                }
            }
        }

        public void toggle(Player player) {
        }

        public boolean isEnabled(Player player) {
            return true;
        }

        public void register() {
        }
    }

    public static interface TickingAugment {
        public void serverTick(Player var1);

        default public void clientTick(Player player) {
        }
    }

    public static enum AugmentOperation {
        RESEARCH,
        ADD,
        REMOVE,
        NEEDS_INIT,
        TOGGLE,
        NONE;

    }

    public static class PlayerStatEnhancingAugment
    extends PlayerAugment {
        private final Holder<Attribute> targetAttribute;
        private final float amount;
        private final AttributeModifier.Operation operation;

        protected PlayerStatEnhancingAugment(ResourceLocation id, Holder<Attribute> targetAttribute, float amount, AttributeModifier.Operation operation) {
            this(id, targetAttribute, amount, operation, false, false);
        }

        protected PlayerStatEnhancingAugment(ResourceLocation id, Holder<Attribute> targetAttribute, float amount, AttributeModifier.Operation operation, boolean toggleable) {
            this(id, targetAttribute, amount, operation, toggleable, false);
        }

        protected PlayerStatEnhancingAugment(ResourceLocation id, Holder<Attribute> targetAttribute, float amount, AttributeModifier.Operation operation, boolean toggleable, boolean autoSync) {
            super(id, toggleable, autoSync);
            this.targetAttribute = targetAttribute;
            this.amount = amount;
            this.operation = operation;
        }

        @Override
        public boolean isInstalled(Player player) {
            AttributeInstance instance = player.getAttribute(this.targetAttribute);
            if (instance == null) {
                return false;
            }
            return instance.hasModifier(this.id);
        }

        @Override
        public void installToPlayer(Player player) {
            AttributeInstance instance = player.getAttribute(this.targetAttribute);
            if (instance == null) {
                return;
            }
            instance.addOrReplacePermanentModifier(new AttributeModifier(this.id, (double)this.amount, this.operation));
            this.onInstalled(player);
            if (this.autoSync && !player.level().isClientSide) {
                NetworkContent.MACHINE_CHANNEL.serverHandle(player).send((Record)new NetworkContent.AugmentOperationSyncPacket(this.id, AugmentOperation.ADD.ordinal()));
            }
        }

        @Override
        public void removeFromPlayer(Player player) {
            AttributeInstance instance = player.getAttribute(this.targetAttribute);
            if (instance == null) {
                return;
            }
            instance.removeModifier(this.id);
            this.onRemoved(player);
            if (this.autoSync && !player.level().isClientSide) {
                NetworkContent.MACHINE_CHANNEL.serverHandle(player).send((Record)new NetworkContent.AugmentOperationSyncPacket(this.id, AugmentOperation.REMOVE.ordinal()));
            }
        }

        @Override
        public boolean isEnabled(Player player) {
            if (!this.toggleable) {
                return true;
            }
            AttributeInstance instance = player.getAttribute(this.targetAttribute);
            if (instance == null) {
                return false;
            }
            AttributeModifier modifier = instance.getModifier(this.id);
            if (modifier == null) {
                return false;
            }
            return modifier.amount() == (double)this.amount;
        }

        @Override
        public void toggle(Player player) {
            AttributeInstance instance = player.getAttribute(this.targetAttribute);
            if (instance == null) {
                return;
            }
            AttributeModifier modifier = instance.getModifier(this.id);
            if (modifier == null) {
                return;
            }
            boolean isActive = modifier.amount() == (double)this.amount;
            float newAmount = isActive ? 0.0f : this.amount;
            instance.addOrReplacePermanentModifier(new AttributeModifier(this.id, (double)newAmount, this.operation));
        }
    }

    public static class PlayerPortalAugment
    extends PlayerAugment {
        private AttachmentType<BlockPos> OWN_TYPE;

        protected PlayerPortalAugment(ResourceLocation id, boolean toggleable) {
            super(id, toggleable, true);
        }

        @Override
        public void register() {
            this.OWN_TYPE = AttachmentRegistry.builder().copyOnDeath().persistent(BlockPos.CODEC).initializer(() -> BlockPos.ZERO).buildAndRegister(this.id);
        }

        public AttachmentType<BlockPos> getOwnType() {
            return this.OWN_TYPE;
        }

        @Override
        public boolean isInstalled(Player player) {
            return player.hasAttached(this.OWN_TYPE);
        }

        @Override
        public void installToPlayer(Player player) {
            player.setAttached(this.OWN_TYPE, (Object)player.blockPosition());
            this.onInstalled(player);
            if (this.autoSync && !player.level().isClientSide) {
                NetworkContent.MACHINE_CHANNEL.serverHandle(player).send((Record)new NetworkContent.AugmentOperationSyncPacket(this.id, AugmentOperation.ADD.ordinal()));
            }
        }

        @Override
        public void removeFromPlayer(Player player) {
            player.removeAttached(this.OWN_TYPE);
            this.onRemoved(player);
            if (this.autoSync && !player.level().isClientSide) {
                NetworkContent.MACHINE_CHANNEL.serverHandle(player).send((Record)new NetworkContent.AugmentOperationSyncPacket(this.id, AugmentOperation.REMOVE.ordinal()));
            }
        }

        @Override
        public void toggle(Player player) {
            super.toggle(player);
            Level world = player.level();
            if (world.isClientSide) {
                return;
            }
            HitResult hitResult = player.pick(6.0, 0.0f, false);
            Vec3 spawnPos = hitResult.getLocation();
            double hitDist = Math.sqrt(hitResult.distanceTo((Entity)player));
            Vec3 spawnToPlayer = spawnPos.subtract(player.position()).normalize().scale(0.3);
            spawnPos = spawnPos.subtract(spawnToPlayer);
            BlockPos targetPos = (BlockPos)player.getAttached(this.OWN_TYPE);
            if (targetPos == null) {
                return;
            }
            PortalEntity portalEntity = (PortalEntity)EntitiesContent.PORTAL_ENTITY.create((ServerLevel)world, spawner -> {}, BlockPos.containing((Position)spawnPos), MobSpawnType.EVENT, false, false);
            if (portalEntity != null) {
                portalEntity.setPos(spawnPos);
                portalEntity.setYRot(-player.getYRot() + 90.0f);
                world.addFreshEntity((Entity)portalEntity);
                portalEntity.target = targetPos.getCenter();
                world.playSound(null, BlockPos.containing((Position)spawnPos), (SoundEvent)SoundEvents.AMBIENT_CAVE.value(), SoundSource.BLOCKS, 2.0f, 1.2f);
            }
        }
    }

    public static abstract class PlayerTickingAugment
    extends PlayerCustomAugment
    implements TickingAugment {
        protected PlayerTickingAugment(ResourceLocation id) {
            super(id);
        }

        protected PlayerTickingAugment(ResourceLocation id, boolean toggleable) {
            super(id, toggleable);
        }
    }

    public static class PlayerCustomAugment
    extends PlayerAugment {
        private AttachmentType<Integer> OWN_TYPE;

        protected PlayerCustomAugment(ResourceLocation id) {
            this(id, false);
        }

        protected PlayerCustomAugment(ResourceLocation id, boolean toggleable) {
            super(id, toggleable, true);
        }

        @Override
        public void register() {
            this.OWN_TYPE = AttachmentRegistry.builder().copyOnDeath().persistent((Codec)Codec.INT).initializer(() -> -1).buildAndRegister(this.id);
        }

        public AttachmentType<Integer> getOwnType() {
            return this.OWN_TYPE;
        }

        @Override
        public boolean isInstalled(Player player) {
            return player.hasAttached(this.OWN_TYPE);
        }

        @Override
        public void installToPlayer(Player player) {
            player.setAttached(this.OWN_TYPE, (Object)0);
            this.onInstalled(player);
            if (this.autoSync && !player.level().isClientSide) {
                NetworkContent.MACHINE_CHANNEL.serverHandle(player).send((Record)new NetworkContent.AugmentOperationSyncPacket(this.id, AugmentOperation.ADD.ordinal()));
            }
        }

        @Override
        public void removeFromPlayer(Player player) {
            player.removeAttached(this.OWN_TYPE);
            this.onRemoved(player);
            if (this.autoSync && !player.level().isClientSide) {
                NetworkContent.MACHINE_CHANNEL.serverHandle(player).send((Record)new NetworkContent.AugmentOperationSyncPacket(this.id, AugmentOperation.REMOVE.ordinal()));
            }
        }
    }
}

