/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.augmenter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.blocks.augmenter.AugmentResearchStationBlock;
import rearth.oritech.block.entity.augmenter.PlayerAugments;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.client.ui.PlayerModifierScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.AugmentRecipe;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventoryProvider;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.SizedIngredient;
import rearth.oritech.util.energy.EnergyApi;
import rearth.oritech.util.energy.containers.SimpleEnergyStorage;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AugmentApplicationEntity
extends BlockEntity
implements BlockEntityTicker<AugmentApplicationEntity>,
MultiblockMachineController,
GeoBlockEntity,
ExtendedScreenHandlerFactory,
InventoryProvider,
EnergyApi.BlockProvider,
ScreenProvider {
    public final Set<ResourceLocation> researchedAugments = new HashSet<ResourceLocation>();
    public static long maxEnergyTransfer = Oritech.CONFIG.augmenterMaxEnergy() / 10L;
    public static long maxEnergyStored = Oritech.CONFIG.augmenterMaxEnergy();
    private final ArrayList<BlockPos> coreBlocksConnected = new ArrayList();
    private float coreQuality = 1.0f;
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean networkDirty = true;
    public final HashMap<Integer, ResearchState> availableStations = new HashMap();
    public boolean screenInvOverride = false;
    public final SimpleContainer inventory = new SimpleContainer(5){

        public void setChanged() {
            super.setChanged();
            AugmentApplicationEntity.this.setChanged();
        }
    };
    private final InventoryStorage inventoryStorage = InventoryStorage.of((Container)this.inventory, null);
    private final EnergyApi.EnergyContainer energyStorage = new SimpleEnergyStorage(maxEnergyTransfer, 0L, maxEnergyStored, this::setChanged);
    private AnimationController<AugmentApplicationEntity> animationController;

    public AugmentApplicationEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.PLAYER_MODIFIER_BLOCK_ENTITY, pos, state);
    }

    public void tick(Level world, BlockPos pos, BlockState state, AugmentApplicationEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        this.screenInvOverride = false;
        for (int i = 0; i < 3; ++i) {
            boolean isDone;
            ResearchState station = this.availableStations.getOrDefault(i, null);
            if (station == null || !station.working) continue;
            boolean bl = isDone = world.getGameTime() > station.researchStartedAt + (long)station.workTime;
            if (!isDone) continue;
            this.researchedAugments.add(station.selectedResearch);
            station.working = false;
            this.setChanged();
        }
        if (this.networkDirty) {
            this.updateNetwork();
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (boolean)false, (HolderLookup.Provider)registryLookup);
        nbt.putLong("rf", this.energyStorage.getAmount());
        this.addMultiblockToNbt(nbt);
        ListTag list = new ListTag();
        for (ResourceLocation augment : this.researchedAugments) {
            list.add((Object)StringTag.valueOf((String)augment.getPath()));
        }
        for (ResearchState station : this.availableStations.values()) {
            if (station == null || !station.working) continue;
            list.add((Object)StringTag.valueOf((String)station.selectedResearch.getPath()));
        }
        nbt.put("researched", (Tag)list);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (HolderLookup.Provider)registryLookup);
        this.energyStorage.setAmount(nbt.getLong("rf"));
        this.loadMultiblockNbtData(nbt);
        ListTag parsedList = nbt.getList("researched", 8);
        for (Tag element : parsedList) {
            ResourceLocation id = Oritech.id(element.getAsString());
            this.researchedAugments.add(id);
        }
    }

    public void researchAugment(ResourceLocation augment, boolean creative, Player player) {
        if (!PlayerAugments.allAugments.containsKey(augment)) {
            Oritech.LOGGER.error("Player augment with id" + String.valueOf(augment) + " not found. This should never happen");
            return;
        }
        if (this.researchedAugments.contains(augment)) {
            Oritech.LOGGER.warn("Player tried to research already researched augment " + String.valueOf(augment));
            return;
        }
        AugmentRecipe recipe = (AugmentRecipe)((RecipeHolder)this.level.getRecipeManager().byKey(augment).get()).value();
        long extracted = this.energyStorage.extract(recipe.getRfCost(), false);
        block0: for (SizedIngredient wantedInput : recipe.getResearchCost()) {
            int takeAmount;
            Ingredient type = wantedInput.ingredient();
            int missingCount = wantedInput.count();
            for (ItemStack stack : this.inventory.items) {
                if (!type.test(stack)) continue;
                takeAmount = Math.min(stack.getCount(), missingCount);
                stack.shrink(takeAmount);
                if ((missingCount -= takeAmount) > 0) continue;
                break;
            }
            for (ItemStack stack : player.getInventory().items) {
                if (!type.test(stack)) continue;
                takeAmount = Math.min(stack.getCount(), missingCount);
                stack.shrink(takeAmount);
                if ((missingCount -= takeAmount) > 0) continue;
                continue block0;
            }
        }
        for (int i = 0; i < 3; ++i) {
            ResearchState station = this.availableStations.getOrDefault(i, null);
            if (station == null || station.working || !BuiltInRegistries.BLOCK.getKey((Object)station.type).equals((Object)recipe.getRequiredStation())) continue;
            station.selectedResearch = augment;
            station.working = true;
            station.researchStartedAt = this.level.getGameTime();
            station.workTime = creative ? 5 : recipe.getTime();
            break;
        }
        this.setChanged();
    }

    public void installAugmentToPlayer(ResourceLocation augment, Player player) {
        if (!PlayerAugments.allAugments.containsKey(augment)) {
            Oritech.LOGGER.error("Player augment with id" + String.valueOf(augment) + " not found. This should never happen");
            return;
        }
        if (!this.researchedAugments.contains(augment)) {
            Oritech.LOGGER.warn("Player tried to install augment with id" + String.valueOf(augment) + " without researching it.");
            return;
        }
        AugmentRecipe recipe = (AugmentRecipe)((RecipeHolder)this.level.getRecipeManager().byKey(augment).get()).value();
        block0: for (SizedIngredient wantedInput : recipe.getApplyCost()) {
            int takeAmount;
            Ingredient type = wantedInput.ingredient();
            int missingCount = wantedInput.count();
            for (ItemStack stack : this.inventory.items) {
                if (!type.test(stack)) continue;
                takeAmount = Math.min(stack.getCount(), missingCount);
                stack.shrink(takeAmount);
                if ((missingCount -= takeAmount) > 0) continue;
                break;
            }
            for (ItemStack stack : player.getInventory().items) {
                if (!type.test(stack)) continue;
                takeAmount = Math.min(stack.getCount(), missingCount);
                stack.shrink(takeAmount);
                if ((missingCount -= takeAmount) > 0) continue;
                continue block0;
            }
        }
        PlayerAugments.PlayerAugment augmentInstance = PlayerAugments.allAugments.get(augment);
        augmentInstance.installToPlayer(player);
        this.markNetDirty();
    }

    public void removeAugmentFromPlayer(ResourceLocation augment, Player player) {
        if (!PlayerAugments.allAugments.containsKey(augment)) {
            Oritech.LOGGER.error("Player augment with id" + String.valueOf(augment) + " not found. This should never happen");
            return;
        }
        PlayerAugments.PlayerAugment augmentInstance = PlayerAugments.allAugments.get(augment);
        augmentInstance.removeFromPlayer(player);
        this.markNetDirty();
    }

    public static void toggleAugmentForPlayer(ResourceLocation augment, Player player) {
        if (!PlayerAugments.allAugments.containsKey(augment)) {
            Oritech.LOGGER.error("Player augment with id" + String.valueOf(augment) + " not found. This should never happen");
            return;
        }
        PlayerAugments.PlayerAugment augmentInstance = PlayerAugments.allAugments.get(augment);
        if (!augmentInstance.isInstalled(player)) {
            Oritech.LOGGER.error("Tried toggling not-installed augment id: " + String.valueOf(augment) + ". This should never happen");
            return;
        }
        augmentInstance.toggle(player);
    }

    public boolean hasPlayerAugment(ResourceLocation augment, Player player) {
        if (!PlayerAugments.allAugments.containsKey(augment)) {
            Oritech.LOGGER.error("Player augment with id" + String.valueOf(augment) + " not found. This should never happen");
            return false;
        }
        PlayerAugments.PlayerAugment augmentInstance = PlayerAugments.allAugments.get(augment);
        return augmentInstance.isInstalled(player);
    }

    public void loadResearchesFromPlayer(Player player) {
        for (ResourceLocation augmentId : PlayerAugments.allAugments.keySet()) {
            PlayerAugments.PlayerAugment augment = PlayerAugments.allAugments.get(augmentId);
            boolean isInstalled = augment.isInstalled(player);
            boolean isResearched = this.researchedAugments.contains(augmentId);
            if (!isInstalled || isResearched) continue;
            this.researchedAugments.add(augmentId);
        }
    }

    public void loadAvailableStations(Player player) {
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        List<BlockPos> targetPositions = List.of(new BlockPos(0, 0, -2), new BlockPos(1, 0, 2), new BlockPos(2, 0, -1));
        for (int i = 0; i < targetPositions.size(); ++i) {
            BlockPos candidatePosOffset = targetPositions.get(i);
            BlockPos candidatePos = new BlockPos(Geometry.offsetToWorldPosition(facing, (Vec3i)candidatePosOffset, (Vec3i)this.worldPosition));
            BlockState candidateState = this.level.getBlockState(candidatePos);
            if (!(candidateState.getBlock() instanceof AugmentResearchStationBlock) || !((Boolean)candidateState.getValue((Property)MultiblockMachine.ASSEMBLED)).booleanValue()) {
                this.availableStations.put(i, null);
                continue;
            }
            if (this.availableStations.containsKey(i) && this.availableStations.get(i) != null && this.availableStations.get((Object)Integer.valueOf((int)i)).type.equals(candidateState.getBlock())) continue;
            ResearchState newState = new ResearchState(candidateState.getBlock(), false, ResourceLocation.parse((String)""), -1, -1L);
            this.availableStations.put(i, newState);
        }
    }

    private void markNetDirty() {
        this.networkDirty = true;
    }

    private void updateNetwork() {
        this.networkDirty = false;
        ArrayList<ResourceLocation> stations = new ArrayList<ResourceLocation>();
        ArrayList<Boolean> states = new ArrayList<Boolean>();
        ArrayList<ResourceLocation> targets = new ArrayList<ResourceLocation>();
        ArrayList<Long> startTimes = new ArrayList<Long>();
        ArrayList<Integer> durations = new ArrayList<Integer>();
        this.availableStations.values().forEach(station -> {
            if (station == null) {
                return;
            }
            stations.add(BuiltInRegistries.BLOCK.getKey((Object)station.type));
            states.add(station.working);
            targets.add(station.selectedResearch);
            startTimes.add(station.researchStartedAt);
            durations.add(station.workTime);
        });
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.AugmentDataPacket(this.worldPosition, this.researchedAugments.stream().toList(), stations, states, targets, startTimes, durations));
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.GenericEnergySyncPacket(this.worldPosition, this.energyStorage.getAmount(), this.energyStorage.getCapacity()));
    }

    public void handleAugmentUpdatePacket(NetworkContent.AugmentDataPacket packet) {
        this.researchedAugments.clear();
        this.researchedAugments.addAll(packet.allResearched());
        this.availableStations.clear();
        for (int i = 0; i < packet.researchBlocks().size(); ++i) {
            Block station = (Block)BuiltInRegistries.BLOCK.get(packet.researchBlocks().get(i));
            Boolean state = packet.researchStates().get(i);
            ResourceLocation target = packet.activeResearches().get(i);
            Integer researchTime = packet.researchTimes().get(i);
            Long startedTime = packet.startedTimes().get(i);
            ResearchState res = new ResearchState(station, state, target, researchTime, startedTime);
            this.availableStations.put(i, res);
        }
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(0, 0, 1), new Vec3i(0, 0, -1), new Vec3i(-1, 0, 0), new Vec3i(-1, 0, 1), new Vec3i(-1, 0, -1), new Vec3i(0, 1, 1), new Vec3i(0, 1, -1), new Vec3i(-1, 1, 0), new Vec3i(-1, 1, 1), new Vec3i(-1, 1, -1));
    }

    @Override
    public Direction getFacingForMultiblock() {
        BlockState state = this.getBlockState();
        return ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite();
    }

    @Override
    public BlockPos getMachinePos() {
        return this.worldPosition;
    }

    @Override
    public Level getMachineWorld() {
        return this.level;
    }

    @Override
    public ArrayList<BlockPos> getConnectedCores() {
        return this.coreBlocksConnected;
    }

    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }

    @Override
    public float getCoreQuality() {
        return this.coreQuality;
    }

    @Override
    public InventoryProvider getInventoryForLink() {
        return this;
    }

    @Override
    public EnergyApi.EnergyContainer getEnergyStorageForLink() {
        return this.energyStorage;
    }

    public void setChanged() {
        super.setChanged();
        this.markNetDirty();
    }

    @Override
    public void playSetupAnimation() {
        this.animationController.setAnimation(MachineBlockEntity.SETUP);
        this.animationController.forceAnimationReset();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        this.animationController = this.getController();
        controllers.add(this.animationController.setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler()));
    }

    private AnimationController<AugmentApplicationEntity> getController() {
        return new AnimationController((GeoAnimatable)this, "machine", 0, state -> {
            if (state.isCurrentAnimation(MachineBlockEntity.SETUP)) {
                if (state.getController().hasAnimationFinished()) {
                    return state.setAndContinue(MachineBlockEntity.IDLE);
                }
                return state.setAndContinue(MachineBlockEntity.SETUP);
            }
            if (((Boolean)this.getBlockState().getValue((Property)MultiblockMachine.ASSEMBLED)).booleanValue()) {
                return state.setAndContinue(MachineBlockEntity.IDLE);
            }
            return state.setAndContinue(MachineBlockEntity.PACKAGED);
        });
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    public Object getScreenOpeningData(ServerPlayer player) {
        return new ModScreens.BasicData(this.worldPosition);
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        this.updateNetwork();
        double dist = player.distanceToSqr(this.worldPosition.getBottomCenter());
        if (dist > 1.0 || this.screenInvOverride) {
            return new BasicMachineScreenHandler(syncId, playerInventory, this);
        }
        return new PlayerModifierScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public EnergyApi.EnergyContainer getStorage(Direction direction) {
        return this.energyStorage;
    }

    @Override
    public Storage<ItemVariant> getInventory(Direction direction) {
        return this.inventoryStorage;
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 30, 30), new ScreenProvider.GuiSlot(1, 50, 30), new ScreenProvider.GuiSlot(2, 70, 30), new ScreenProvider.GuiSlot(3, 90, 30), new ScreenProvider.GuiSlot(4, 110, 30));
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 0.0f;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public boolean showExpansionPanel() {
        return false;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.MODIFIED_INV_SCREEN;
    }

    public static class ResearchState {
        public Block type;
        public boolean working;
        public ResourceLocation selectedResearch;
        public int workTime;
        public long researchStartedAt;

        public ResearchState(Block type, boolean working, ResourceLocation selectedResearch, int workTime, long researchStartedAt) {
            this.type = type;
            this.working = working;
            this.selectedResearch = selectedResearch;
            this.workTime = workTime;
            this.researchStartedAt = researchStartedAt;
        }

        public String toString() {
            return "ResearchState{type=" + String.valueOf(this.type) + ", working=" + this.working + ", selectedResearch=" + String.valueOf(this.selectedResearch) + ", workTime=" + this.workTime + ", researchStartedAt=" + this.researchStartedAt + "}";
        }
    }
}

