/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.arcane;

import java.util.List;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.arcane.BaseSoulCollectionEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.CatalystScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.ComparatorOutputProvider;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventoryProvider;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.energy.EnergyApi;
import rearth.oritech.util.energy.containers.SimpleEnergyStorage;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EnchantmentCatalystBlockEntity
extends BaseSoulCollectionEntity
implements InventoryProvider,
EnergyApi.BlockProvider,
ScreenProvider,
ComparatorOutputProvider,
GeoBlockEntity,
BlockEntityTicker<EnchantmentCatalystBlockEntity>,
ExtendedScreenHandlerFactory<ModScreens.BasicData> {
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    public static final RawAnimation STABILIZED = RawAnimation.begin().thenLoop("stabilized");
    public static final RawAnimation UNSTABLE = RawAnimation.begin().thenLoop("unstable");
    public final int baseSoulCapacity = Oritech.CONFIG.catalystBaseSouls();
    public final int maxProgress = 20;
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int collectedSouls;
    public int maxSouls = Oritech.CONFIG.catalystBaseSouls();
    private int unstableTicks;
    private int progress;
    private boolean isHyperEnchanting;
    private boolean networkDirty;
    private String lastAnimation = "idle";
    private int lastComparatorOutput;
    public final SimpleContainer inventory = new SimpleContainer(2){

        public void setChanged() {
            EnchantmentCatalystBlockEntity.this.setChanged();
        }
    };
    public final SimpleEnergyStorage energyStorage = new SimpleEnergyStorage(10000L, 0L, 50000L);
    protected final InventoryStorage inventoryStorage = InventoryStorage.of((Container)this.inventory, null);

    public EnchantmentCatalystBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.ENCHANTMENT_CATALYST_BLOCK_ENTITY, pos, state);
    }

    public void tick(Level world, BlockPos pos, BlockState state, EnchantmentCatalystBlockEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        if (this.energyStorage.getAmount() > 0L) {
            long gainedSoulCapacity = this.energyStorage.getAmount() / (long)Oritech.CONFIG.catalystRFPerSoul();
            this.energyStorage.setAmount(0L);
            long newMax = (long)this.baseSoulCapacity + gainedSoulCapacity;
            this.adjustMaxSouls(newMax);
            this.setChanged();
        } else if (this.maxSouls > this.baseSoulCapacity) {
            this.adjustMaxSouls(this.baseSoulCapacity);
        }
        if (this.collectedSouls > this.maxSouls) {
            ++this.unstableTicks;
            ParticleContent.MELTDOWN_IMMINENT.spawn(world, pos.getCenter(), (Object)(this.unstableTicks / 4));
            if (this.unstableTicks > 60) {
                this.doExplosion();
            }
            return;
        }
        this.unstableTicks = 0;
        if (this.canProceed()) {
            this.networkDirty = true;
            ++this.progress;
            ParticleContent.SOUL_USED.spawn(world, pos.getCenter().add(0.0, 0.3, 0.0), (Object)(this.isHyperEnchanting ? 15 : 3));
            if (this.progress >= 20) {
                this.enchantInput();
                ParticleContent.ASSEMBLER_WORKING.spawn(world, pos.getCenter(), (Object)30);
                this.progress = 0;
                this.isHyperEnchanting = false;
            }
        } else {
            this.progress = 0;
        }
        if (this.networkDirty) {
            this.networkDirty = false;
            this.updateNetwork();
            BaseSoulCollectionEntity.DeathListener.resetEvents();
            this.updateAnimation();
            int level = this.calculateComparatorLevel();
            if (level != this.lastComparatorOutput) {
                this.lastComparatorOutput = level;
                world.updateNeighbourForOutputSignal(pos, state.getBlock());
            }
        }
        if (world.getGameTime() % 60L == 0L) {
            this.lastAnimation = "idle";
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (boolean)false, (HolderLookup.Provider)registryLookup);
        nbt.putInt("souls", this.collectedSouls);
        nbt.putInt("maxSouls", this.maxSouls);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (HolderLookup.Provider)registryLookup);
        this.collectedSouls = nbt.getInt("souls");
        this.maxSouls = nbt.getInt("maxSouls");
    }

    private void doExplosion() {
        Vec3 center = this.worldPosition.getCenter();
        double strength = Math.sqrt(this.collectedSouls - this.baseSoulCapacity);
        this.level.explode(null, center.x, center.y, center.z, (float)((int)strength), true, Level.ExplosionInteraction.BLOCK);
        this.level.removeBlock(this.worldPosition, false);
    }

    private void adjustMaxSouls(long target) {
        if ((long)this.maxSouls > target) {
            --this.maxSouls;
        } else if ((long)this.maxSouls < target) {
            ++this.maxSouls;
        }
        this.networkDirty = true;
    }

    private void enchantInput() {
        ItemStack bookCandidate = this.inventory.getItem(0);
        if (!bookCandidate.getItem().equals(Items.ENCHANTED_BOOK) || !bookCandidate.has(DataComponents.STORED_ENCHANTMENTS)) {
            return;
        }
        Holder enchantment = (Holder)((ItemEnchantments)bookCandidate.get(DataComponents.STORED_ENCHANTMENTS)).keySet().stream().findFirst().get();
        ItemStack inputStack = this.inventory.getItem(1);
        int toolLevel = inputStack.getEnchantments().getLevel(enchantment);
        inputStack.enchant(enchantment, toolLevel + 1);
        this.collectedSouls -= this.getEnchantmentCost((Enchantment)enchantment.value(), toolLevel + 1, this.isHyperEnchanting);
        if (this.isHyperEnchanting) {
            this.inventory.setItem(0, ItemStack.EMPTY);
        }
    }

    private boolean hasEnoughSouls(Enchantment enchantment, int targetLevel) {
        int resultingCost = this.getEnchantmentCost(enchantment, targetLevel, this.isHyperEnchanting);
        return this.collectedSouls >= resultingCost;
    }

    private int getEnchantmentCost(Enchantment enchantment, int targetLevel, boolean hyper) {
        int baseCost = enchantment.getAnvilCost();
        int resultingCost = baseCost * targetLevel * Oritech.CONFIG.catalystCostMultiplier();
        if (hyper) {
            resultingCost = resultingCost * Oritech.CONFIG.catalystHyperMultiplier() + Oritech.CONFIG.catalystBaseSouls();
        }
        return resultingCost;
    }

    public int getDisplayedCost() {
        if (this.inventory.getItem(0).isEmpty() || this.inventory.getItem(1).isEmpty()) {
            return 0;
        }
        ItemStack bookCandidate = this.inventory.getItem(0);
        if (bookCandidate.getItem().equals(Items.ENCHANTED_BOOK) && bookCandidate.has(DataComponents.STORED_ENCHANTMENTS)) {
            Holder enchantment = (Holder)((ItemEnchantments)bookCandidate.get(DataComponents.STORED_ENCHANTMENTS)).keySet().stream().findFirst().get();
            int maxLevel = ((Enchantment)enchantment.value()).getMaxLevel();
            int bookLevel = ((ItemEnchantments)bookCandidate.get(DataComponents.STORED_ENCHANTMENTS)).getLevel(enchantment);
            if (bookLevel != maxLevel) {
                return 0;
            }
            ItemStack inputStack = this.inventory.getItem(1);
            int toolLevel = inputStack.getEnchantments().getLevel(enchantment);
            boolean isHyper = toolLevel >= maxLevel;
            return this.getEnchantmentCost((Enchantment)enchantment.value(), toolLevel + 1, isHyper);
        }
        return 0;
    }

    private boolean canProceed() {
        if (this.inventory.getItem(0).isEmpty() || this.inventory.getItem(1).isEmpty()) {
            return false;
        }
        ItemStack bookCandidate = this.inventory.getItem(0);
        if (bookCandidate.getItem().equals(Items.ENCHANTED_BOOK) && bookCandidate.has(DataComponents.STORED_ENCHANTMENTS)) {
            Holder enchantment = (Holder)((ItemEnchantments)bookCandidate.get(DataComponents.STORED_ENCHANTMENTS)).keySet().stream().findFirst().get();
            int maxLevel = ((Enchantment)enchantment.value()).getMaxLevel();
            int level = ((ItemEnchantments)bookCandidate.get(DataComponents.STORED_ENCHANTMENTS)).getLevel(enchantment);
            ItemStack inputStack = this.inventory.getItem(1);
            int toolLevel = inputStack.getEnchantments().getLevel(enchantment);
            this.isHyperEnchanting = toolLevel >= maxLevel;
            return level == maxLevel && this.hasEnoughSouls((Enchantment)enchantment.value(), toolLevel + 1);
        }
        return false;
    }

    @Override
    public void onSoulIncoming(Vec3 source) {
        float distance = (float)source.distanceTo(this.worldPosition.getCenter());
        ++this.collectedSouls;
        this.networkDirty = true;
        Vec3 soulPath = this.worldPosition.getCenter().subtract(source);
        ParticleContent.SoulParticleData animData = new ParticleContent.SoulParticleData(soulPath, (int)EnchantmentCatalystBlockEntity.getSoulTravelDuration(distance));
        ParticleContent.WANDERING_SOUL.spawn(this.level, source.add(0.0, (double)0.7f, 0.0), (Object)animData);
    }

    @Override
    public boolean canAcceptSoul() {
        return this.collectedSouls < this.maxSouls;
    }

    @Override
    public int getComparatorOutput() {
        return this.calculateComparatorLevel();
    }

    private int calculateComparatorLevel() {
        return (int)((float)this.collectedSouls / (float)this.maxSouls * 16.0f);
    }

    private void updateNetwork() {
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.CatalystSyncPacket(this.worldPosition, this.collectedSouls, this.progress, this.isHyperEnchanting, this.maxSouls));
    }

    public void handleNetworkPacket(NetworkContent.CatalystSyncPacket packet) {
        this.isHyperEnchanting = packet.isHyperEnchanting();
        this.progress = packet.progress();
        this.collectedSouls = packet.storedSouls();
        this.maxSouls = packet.maxSouls();
    }

    public ModScreens.BasicData getScreenOpeningData(ServerPlayer player) {
        return new ModScreens.BasicData(this.worldPosition);
    }

    public Component getDisplayName() {
        return Component.literal((String)"");
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        this.updateNetwork();
        return new CatalystScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public Storage<ItemVariant> getInventory(Direction direction) {
        return this.inventoryStorage;
    }

    @Override
    public EnergyApi.EnergyContainer getStorage(Direction direction) {
        return this.energyStorage;
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 56, 35), new ScreenProvider.GuiSlot(1, 75, 35));
    }

    @Override
    public ScreenProvider.BarConfiguration getEnergyConfiguration() {
        return new ScreenProvider.BarConfiguration(7, 7, 18, 71);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "machine", 4, state -> {
            if (state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
                return state.setAndContinue(IDLE);
            }
            return PlayState.CONTINUE;
        }).triggerableAnim("stabilized", STABILIZED).triggerableAnim("idle", IDLE).triggerableAnim("unstable", UNSTABLE).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler()));
    }

    private void updateAnimation() {
        String targetAnim = "idle";
        if (this.maxSouls > this.baseSoulCapacity) {
            targetAnim = "stabilized";
        }
        if (this.unstableTicks > 0) {
            targetAnim = "unstable";
        }
        if (!targetAnim.equals(this.lastAnimation)) {
            this.triggerAnim("machine", targetAnim);
            this.lastAnimation = targetAnim;
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 0.0f;
    }

    @Override
    public float getProgress() {
        return (float)this.progress / 20.0f;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.CATALYST_SCREEN;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public boolean showEnergy() {
        return true;
    }
}

