/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.addons;

import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.block.entity.addons.AddonBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.RedstoneAddonScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.ComparatorOutputProvider;

public class RedstoneAddonBlockEntity
extends AddonBlockEntity
implements BlockEntityTicker<RedstoneAddonBlockEntity>,
ExtendedScreenHandlerFactory,
ComparatorOutputProvider {
    private RedstoneControllable cachedController;
    public RedstoneMode activeMode = RedstoneMode.INPUT_CONTROL;
    public int monitoredSlot = 0;
    public int currentOutput;

    public RedstoneAddonBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.REDSTONE_ADDON_ENTITY, pos, state);
    }

    public void tick(Level world, BlockPos pos, BlockState state, RedstoneAddonBlockEntity blockEntity) {
        if (world.isClientSide || !this.isConnected() || this.activeMode == RedstoneMode.INPUT_CONTROL) {
            return;
        }
        int lastOutput = this.currentOutput;
        switch (this.activeMode.ordinal()) {
            case 0: {
                this.currentOutput = this.cachedController.getComparatorEnergyAmount();
                break;
            }
            case 1: {
                this.currentOutput = this.cachedController.getComparatorSlotAmount(this.monitoredSlot);
                break;
            }
            case 2: {
                this.currentOutput = this.cachedController.getComparatorProgress();
                break;
            }
            case 3: {
                this.currentOutput = this.cachedController.getComparatorActiveState();
                break;
            }
            case 4: {
                this.currentOutput = 0;
            }
        }
        if (this.currentOutput != lastOutput) {
            this.setChanged();
        }
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt("slot", this.monitoredSlot);
        nbt.putInt("mode", this.activeMode.ordinal());
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.monitoredSlot = nbt.getInt("slot");
        this.activeMode = RedstoneMode.values()[nbt.getInt("mode")];
    }

    public void sendDataToClient() {
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.RedstoneAddonSyncPacket(this.worldPosition, this.getControllerPos(), this.monitoredSlot, this.activeMode.ordinal(), this.currentOutput));
    }

    public void sendDataToServer() {
        NetworkContent.UI_CHANNEL.clientHandle().send((Record)new NetworkContent.RedstoneAddonSyncPacket(this.worldPosition, this.getControllerPos(), this.monitoredSlot, this.activeMode.ordinal(), this.currentOutput));
    }

    private boolean isConnected() {
        Boolean isUsed = (Boolean)this.getBlockState().getValue((Property)MachineAddonBlock.ADDON_USED);
        return isUsed != false && this.getCachedController() != null;
    }

    public RedstoneControllable getCachedController() {
        if (this.cachedController != null) {
            return this.cachedController;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.getControllerPos());
        if (blockEntity instanceof RedstoneControllable) {
            RedstoneControllable redstoneControllable;
            this.cachedController = redstoneControllable = (RedstoneControllable)blockEntity;
        }
        return this.cachedController;
    }

    public void setRedstonePowered(boolean isPowered) {
        this.setChanged();
        if (this.activeMode != RedstoneMode.INPUT_CONTROL) {
            return;
        }
        if (this.getCachedController() != null) {
            this.cachedController.onRedstoneEvent(isPowered);
        }
    }

    @Override
    public int getComparatorOutput() {
        return this.currentOutput;
    }

    public Object getScreenOpeningData(ServerPlayer player) {
        this.sendDataToClient();
        return new ModScreens.BasicData(this.worldPosition);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new RedstoneAddonScreenHandler(syncId, playerInventory, this);
    }

    public Component getDisplayName() {
        return Component.literal((String)"");
    }

    public void handleClientBound(NetworkContent.RedstoneAddonSyncPacket message) {
        this.currentOutput = message.currentOutput();
        this.activeMode = RedstoneMode.values()[message.targetMode()];
        this.monitoredSlot = message.targetSlot();
        this.setControllerPos(message.controllerPos());
    }

    public void handleServerBound(NetworkContent.RedstoneAddonSyncPacket message) {
        this.activeMode = RedstoneMode.values()[message.targetMode()];
        this.monitoredSlot = message.targetSlot();
    }

    public static enum RedstoneMode {
        OUTPUT_POWER,
        OUTPUT_SLOT,
        OUTPUT_PROGRESS,
        OUTPUT_ACTIVE,
        INPUT_CONTROL;

    }

    public static interface RedstoneControllable
    extends ComparatorOutputProvider {
        public int getComparatorEnergyAmount();

        public int getComparatorSlotAmount(int var1);

        public int getComparatorProgress();

        public int getComparatorActiveState();

        public void onRedstoneEvent(boolean var1);

        @Override
        default public int getComparatorOutput() {
            return 0;
        }
    }
}

