/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.addons;

import java.util.Objects;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.block.entity.addons.AddonBlockEntity;
import rearth.oritech.client.ui.InventoryProxyScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.ImplementedInventory;
import rearth.oritech.util.MachineAddonController;

public class InventoryProxyAddonBlockEntity
extends AddonBlockEntity
implements ImplementedInventory,
ExtendedScreenHandlerFactory {
    private MachineAddonController cachedController;
    private int targetSlot = 0;

    public InventoryProxyAddonBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.INVENTORY_PROXY_ADDON_ENTITY, pos, state);
    }

    private boolean isConnected() {
        Boolean isUsed = (Boolean)this.getBlockState().getValue((Property)MachineAddonBlock.ADDON_USED);
        return isUsed != false && this.getCachedController() != null;
    }

    private MachineAddonController getCachedController() {
        if (this.cachedController != null) {
            return this.cachedController;
        }
        this.cachedController = (MachineAddonController)Objects.requireNonNull(this.level).getBlockEntity(this.getControllerPos());
        return this.cachedController;
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        if (!this.isConnected()) {
            return NonNullList.create();
        }
        return this.getCachedController().getInventoryForAddon().items;
    }

    @Override
    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction side) {
        return slot == this.targetSlot;
    }

    @Override
    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction side) {
        return slot == this.targetSlot;
    }

    public Object getScreenOpeningData(ServerPlayer player) {
        return new InventoryProxyScreenHandler.InvProxyData(this.worldPosition, this.getControllerPos(), this.targetSlot);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"title.oritech.inventory_proxy");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new InventoryProxyScreenHandler(syncId, playerInventory, this, this.getCachedController().getScreenProvider(), this.targetSlot);
    }

    public void setTargetSlot(int targetSlot) {
        this.targetSlot = targetSlot;
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt("target_slot", this.targetSlot);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.targetSlot = nbt.getInt("target_slot");
    }
}

