/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.addons;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.MachineAddonProvider;

public class AddonBlockEntity
extends BlockEntity
implements MachineAddonProvider {
    private BlockPos controllerPos = BlockPos.ZERO;

    public AddonBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.ADDON_ENTITY, pos, state);
    }

    public AddonBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void setControllerPos(BlockPos pos) {
        this.controllerPos = pos;
    }

    @Override
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt("controller_x", this.controllerPos.getX());
        nbt.putInt("controller_y", this.controllerPos.getY());
        nbt.putInt("controller_z", this.controllerPos.getZ());
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.controllerPos = new BlockPos(nbt.getInt("controller_x"), nbt.getInt("controller_y"), nbt.getInt("controller_z"));
    }
}

