/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.accelerator;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.ExpandableEnergyStorageBlockEntity;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.energy.EnergyApi;
import rearth.oritech.util.energy.containers.DynamicEnergyStorage;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ParticleCollectorBlockEntity
extends BlockEntity
implements BlockEntityTicker<ParticleCollectorBlockEntity>,
EnergyApi.BlockProvider,
GeoBlockEntity {
    protected final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(Oritech.CONFIG.collectorEnergyStorage(), 0L, Oritech.CONFIG.collectorEnergyStorage(), () -> ((ParticleCollectorBlockEntity)this).setChanged());
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final RawAnimation WORK = RawAnimation.begin().thenPlayAndHold("collect");
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    private boolean setup = false;
    private final AnimationController<ParticleCollectorBlockEntity> animationController = this.getAnimationController();

    public ParticleCollectorBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.PARTICLE_COLLECTOR_BLOCK_ENTITY, pos, state);
    }

    @Override
    public EnergyApi.EnergyContainer getStorage(@Nullable Direction direction) {
        return this.energyStorage;
    }

    public void onParticleCollided() {
        this.onParticleCollided(Oritech.CONFIG.blackHoleTachyonEnergy());
    }

    public void onParticleCollided(int amount) {
        this.energyStorage.amount = Math.min(this.energyStorage.capacity, this.energyStorage.amount + (long)amount);
        this.energyStorage.update();
        this.triggerAnimation();
    }

    public void tick(Level world, BlockPos pos, BlockState state, ParticleCollectorBlockEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        if (!this.setup) {
            this.triggerAnimation();
            this.setup = true;
        }
        if (this.energyStorage.amount <= 0L) {
            return;
        }
        Tuple<Direction, BlockPos> target = ExpandableEnergyStorageBlockEntity.getOutputPosition(pos, ((Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING)).getOpposite());
        EnergyApi.EnergyContainer candidate = EnergyApi.BLOCK.find(world, (BlockPos)target.getB(), (Direction)target.getA());
        if (candidate != null) {
            EnergyApi.transfer(this.energyStorage, candidate, Long.MAX_VALUE, false);
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putLong("energy", this.energyStorage.getAmount());
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.energyStorage.setAmount(nbt.getLong("energy"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.animationController);
    }

    private AnimationController<ParticleCollectorBlockEntity> getAnimationController() {
        return new AnimationController((GeoAnimatable)this, state -> PlayState.CONTINUE);
    }

    public void triggerAnimation() {
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.ParticleAcceleratorAnimationPacket(this.worldPosition));
    }

    public void playAnimation() {
        this.animationController.setAnimation(WORK);
        this.animationController.forceAnimationReset();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }
}

