/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.accelerator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.Oritech;
import rearth.oritech.block.blocks.accelerator.AcceleratorPassthroughBlock;
import rearth.oritech.block.entity.accelerator.ParticleCollectorBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.network.NetworkContent;

public class BlackHoleBlockEntity
extends BlockEntity
implements BlockEntityTicker<BlackHoleBlockEntity> {
    public BlockPos currentlyPullingFrom;
    public BlockState currentlyPulling;
    public long pullingStartedAt;
    public long pullTime;
    private int waitTicks;
    private final Map<BlockPos, ParticleCollectorBlockEntity> cachedCollectors = new HashMap<BlockPos, ParticleCollectorBlockEntity>();

    public BlackHoleBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.BLACK_HOLE_ENTITY, pos, state);
    }

    public void tick(Level world, BlockPos pos, BlockState state, BlackHoleBlockEntity blockEntity) {
        if (world.isClientSide || this.waitTicks-- > 0) {
            return;
        }
        if (this.currentlyPullingFrom != null && this.pullingStartedAt + this.pullTime - 5L < world.getGameTime()) {
            this.onPullingFinished();
            this.currentlyPullingFrom = null;
        }
        if (this.currentlyPullingFrom != null) {
            return;
        }
        int pullRange = Oritech.CONFIG.pullRange();
        for (BlockPos candidate : BlockPos.withinManhattan((BlockPos)pos, (int)pullRange, (int)pullRange, (int)pullRange)) {
            BlockState candidateState = world.getBlockState(candidate);
            if (candidate.equals((Object)pos) || candidateState.isAir() || candidateState.liquid() || candidateState.getBlock().equals(Blocks.MOVING_PISTON) || candidateState.getBlock().equals(BlockContent.BLACK_HOLE_BLOCK)) continue;
            this.currentlyPullingFrom = candidate;
            this.currentlyPulling = candidateState;
            this.pullingStartedAt = world.getGameTime();
            this.pullTime = (long)candidate.distManhattan((Vec3i)pos) * (long)Oritech.CONFIG.pullTimeMultiplier();
            NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.BlackHoleSuckPacket(pos, this.currentlyPullingFrom, this.pullingStartedAt, this.pullTime));
            world.setBlockAndUpdate(candidate, Blocks.AIR.defaultBlockState());
            return;
        }
        if (this.currentlyPullingFrom == null) {
            this.waitTicks = Oritech.CONFIG.idleWaitTicks();
        }
    }

    private void onPullingFinished() {
        BlockPos from = this.currentlyPullingFrom;
        Vec3 pulledDir = Vec3.atLowerCornerOf((Vec3i)this.worldPosition.subtract((Vec3i)from));
        pulledDir = pulledDir.normalize();
        for (int i = 0; i < 5; ++i) {
            Vec3 shootDir = pulledDir.offsetRandom(this.level.getRandom(), 0.5f);
            BlockPos cacheKey = BlackHoleBlockEntity.getRayEnd(this.worldPosition.getCenter(), shootDir.normalize());
            ParticleCollectorBlockEntity cachedHit = this.tryGetCachedCollector(cacheKey);
            if (cachedHit != null) {
                ParticleContent.BLACK_HOLE_EMISSION.spawn(this.level, this.worldPosition.getCenter(), (Object)cachedHit.getBlockPos().getCenter());
                cachedHit.onParticleCollided();
                continue;
            }
            BlockPos impactPos = BlackHoleBlockEntity.basicRaycast(this.worldPosition.getCenter().add(pulledDir.scale(1.2)), shootDir, 12, this.level);
            if (impactPos != null) {
                ParticleContent.BLACK_HOLE_EMISSION.spawn(this.level, this.worldPosition.getCenter(), (Object)impactPos.getCenter());
                BlockEntity candidate = this.level.getBlockEntity(impactPos);
                if (!(candidate instanceof ParticleCollectorBlockEntity)) break;
                ParticleCollectorBlockEntity collectorEntity = (ParticleCollectorBlockEntity)candidate;
                collectorEntity.onParticleCollided();
                this.cachedCollectors.put(cacheKey, collectorEntity);
                continue;
            }
            ParticleContent.BLACK_HOLE_EMISSION.spawn(this.level, this.worldPosition.getCenter(), (Object)this.worldPosition.getCenter().add(shootDir.scale(15.0)));
            break;
        }
    }

    private static BlockPos getRayEnd(Vec3 shotFrom, Vec3 shotDirection) {
        return BlockPos.containing((Position)shotFrom.add(shotDirection.scale(12.0)));
    }

    private ParticleCollectorBlockEntity tryGetCachedCollector(BlockPos key) {
        ParticleCollectorBlockEntity cachedResult = this.cachedCollectors.get(key);
        if (cachedResult == null) {
            return null;
        }
        if (cachedResult.isRemoved()) {
            this.cachedCollectors.remove(key);
            return null;
        }
        return cachedResult;
    }

    public static BlockPos basicRaycast(Vec3 from, Vec3 direction, int range, Level world) {
        HashSet<BlockPos> checkedPositions = new HashSet<BlockPos>();
        for (float i = 0.0f; i < (float)range; i += 0.3f) {
            Vec3 to = from.add(direction.scale((double)i));
            BlockPos targetBlockPos = BlockPos.containing((Position)to);
            if (checkedPositions.contains(targetBlockPos)) continue;
            checkedPositions.add(targetBlockPos);
            BlockState targetState = world.getBlockState(targetBlockPos);
            if (BlackHoleBlockEntity.canPassThrough(targetState, targetBlockPos)) continue;
            return targetBlockPos;
        }
        return null;
    }

    private static boolean canPassThrough(BlockState state, BlockPos blockPos) {
        return state.isAir() || state.liquid() || state.is(TagContent.LASER_PASSTHROUGH) || state.getBlock() instanceof AcceleratorPassthroughBlock;
    }

    public void onClientPullEvent(NetworkContent.BlackHoleSuckPacket packet) {
        this.currentlyPullingFrom = packet.from();
        this.pullTime = packet.duration();
        this.pullingStartedAt = this.level.getGameTime();
        this.currentlyPulling = this.level.getBlockState(packet.from());
    }
}

