/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.accelerator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.blocks.accelerator.AcceleratorPassthroughBlock;
import rearth.oritech.block.blocks.accelerator.AcceleratorRingBlock;
import rearth.oritech.block.entity.accelerator.AcceleratorControllerBlockEntity;
import rearth.oritech.block.entity.accelerator.AcceleratorSensorBlockEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.util.Geometry;

public class AcceleratorParticleLogic {
    private final BlockPos pos;
    private final ServerLevel world;
    private final AcceleratorControllerBlockEntity entity;
    private static final Map<CompPair<BlockPos, Vec3i>, BlockPos> cachedGates = new HashMap<CompPair<BlockPos, Vec3i>, BlockPos>();
    private static final Map<BlockPos, BlockPos> activeParticles = new HashMap<BlockPos, BlockPos>();

    public AcceleratorParticleLogic(BlockPos pos, ServerLevel world, AcceleratorControllerBlockEntity entity) {
        this.pos = pos;
        this.world = world;
        this.entity = entity;
    }

    public void update(ActiveParticle particle) {
        float timePassed = 0.05f;
        ArrayList<Vec3> renderedTrail = new ArrayList<Vec3>();
        renderedTrail.add(particle.position);
        HashSet<BlockPos> checkedPositions = new HashSet<BlockPos>();
        float availableDistance = particle.velocity * timePassed;
        while ((double)availableDistance > 0.001) {
            BlockEntity blockEntity;
            Block gateBlock;
            boolean wasBend;
            BlockPos usedGateForCollision;
            if (particle.nextGate == null) {
                this.exitParticle(particle, new Vec3(0.0, 0.0, 0.0), AcceleratorControllerBlockEntity.ParticleEvent.ERROR);
                return;
            }
            Vec3 path = particle.nextGate.getCenter().subtract(particle.position);
            double pathLength = path.length();
            double moveDist = Math.min(pathLength, (double)availableDistance);
            availableDistance = (float)((double)availableDistance - moveDist);
            Vec3 movedBy = path.normalize().scale(moveDist);
            boolean abTest = movedBy.x > 0.0 || movedBy.y > 0.0;
            BlockPos validLastGate = particle.lastGate == null ? particle.nextGate : particle.lastGate;
            BlockPos blockPos = usedGateForCollision = abTest ? validLastGate : particle.nextGate;
            if (this.updateParticleCollision(Vec3.atLowerCornerOf((Vec3i)usedGateForCollision), particle)) {
                return;
            }
            particle.position = particle.position.add(movedBy);
            renderedTrail.add(particle.position);
            particle.lastBendDistance = (float)((double)particle.lastBendDistance + moveDist);
            this.checkParticleEntityCollision(particle.position, particle, checkedPositions);
            if (!(moveDist >= pathLength - (double)0.1f)) continue;
            BlockPos reachedGate = particle.nextGate;
            Vec3i nextDirection = this.getGateExitDirection(particle.lastGate, particle.nextGate);
            BlockPos nextGate = this.findNextGateCached(reachedGate, nextDirection, particle.velocity);
            if (nextGate == null) {
                this.exitParticle(particle, Vec3.atLowerCornerOf((Vec3i)nextDirection), AcceleratorControllerBlockEntity.ParticleEvent.EXITED_NO_GATE);
                return;
            }
            BlockPos gateOffset = particle.nextGate.subtract((Vec3i)particle.lastGate);
            Vec3i lastDirection = new Vec3i(Math.clamp((long)gateOffset.getX(), -1, 1), 0, Math.clamp((long)gateOffset.getZ(), -1, 1));
            boolean bl = wasBend = !lastDirection.equals((Object)nextDirection);
            if (wasBend) {
                float requiredDist;
                float combinedDist = AcceleratorParticleLogic.getParticleBendDist(particle.lastBendDistance, particle.lastBendDistance2);
                if (combinedDist <= (requiredDist = AcceleratorParticleLogic.getRequiredBendDist(particle.velocity))) {
                    this.exitParticle(particle, Vec3.atLowerCornerOf((Vec3i)particle.nextGate.subtract((Vec3i)particle.lastGate)), AcceleratorControllerBlockEntity.ParticleEvent.EXITED_FAST);
                    return;
                }
                particle.lastBendDistance2 = particle.lastBendDistance;
                particle.lastBendDistance = 0.0f;
            }
            if ((gateBlock = this.world.getBlockState(reachedGate).getBlock()).equals(BlockContent.ACCELERATOR_MOTOR)) {
                this.entity.handleParticleMotorInteraction(reachedGate);
            } else if (gateBlock.equals(BlockContent.ACCELERATOR_SENSOR) && (blockEntity = this.world.getBlockEntity(reachedGate)) instanceof AcceleratorSensorBlockEntity) {
                AcceleratorSensorBlockEntity sensorEntity = (AcceleratorSensorBlockEntity)blockEntity;
                sensorEntity.measureParticle(particle);
            }
            particle.nextGate = nextGate;
            particle.lastGate = reachedGate;
        }
        this.entity.onParticleMoved(renderedTrail);
    }

    private void checkParticleEntityCollision(Vec3 position, ActiveParticle particle, Set<BlockPos> alreadyChecked) {
        BlockPos blockPos = BlockPos.containing((Position)position);
        if (alreadyChecked.contains(blockPos)) {
            return;
        }
        alreadyChecked.add(blockPos);
        List targets = this.world.getEntitiesOfClass(LivingEntity.class, new AABB(blockPos), elem -> elem.isAlive() && elem.isAttackable() && !elem.isSpectator());
        float remainingMomentum = particle.velocity;
        for (LivingEntity mob : targets) {
            float usedMomentum;
            if (!((remainingMomentum -= (usedMomentum = this.entity.handleParticleEntityCollision(blockPos, particle, remainingMomentum, mob))) <= 0.1f)) continue;
            return;
        }
        particle.velocity = remainingMomentum;
    }

    private void exitParticle(ActiveParticle particle, Vec3 direction, AcceleratorControllerBlockEntity.ParticleEvent reason) {
        Vec3 exitFrom = particle.position;
        double distance = Math.max(Math.sqrt(particle.velocity), 0.4) * 0.9;
        Vec3 exitTo = exitFrom.add(direction.normalize().scale(distance));
        this.entity.onParticleExited(exitFrom, exitTo, particle.lastGate, direction, reason);
        int searchDist = (int)distance;
        Vec3i searchDirection = new Vec3i((int)Math.round(direction.x), 0, (int)Math.round(direction.z));
        BlockPos searchStart = particle.nextGate;
        if (searchStart == null) {
            searchStart = particle.lastGate;
        }
        float remainingMomentum = particle.velocity;
        for (int i = 1; i <= searchDist; ++i) {
            boolean targetableBlock;
            float usedMomentum;
            BlockPos checkPos = searchStart.offset(searchDirection.multiply(i));
            List targets = this.world.getEntitiesOfClass(LivingEntity.class, new AABB(checkPos), elem -> elem.isAlive() && elem.isAttackable() && !elem.isSpectator());
            for (LivingEntity mob : targets) {
                if (!((remainingMomentum -= (usedMomentum = this.entity.handleParticleEntityCollision(checkPos, particle, remainingMomentum, mob))) <= 0.1f)) continue;
                return;
            }
            BlockState block = this.world.getBlockState(checkPos);
            boolean bl = targetableBlock = !block.isAir() && !(block.getBlock() instanceof AcceleratorPassthroughBlock);
            if (!targetableBlock || !((remainingMomentum -= (usedMomentum = this.entity.handleParticleBlockCollision(checkPos, particle, remainingMomentum, block))) <= 0.1f)) continue;
            return;
        }
    }

    private boolean updateParticleCollision(Vec3 position, ActiveParticle particle) {
        BlockPos blockPos = new BlockPos((int)position.x, (int)position.y, (int)position.z);
        if (activeParticles.containsKey(blockPos) && !activeParticles.get(blockPos).equals((Object)this.pos)) {
            AcceleratorControllerBlockEntity secondAccelerator;
            BlockPos secondControllerPos = activeParticles.get(blockPos);
            BlockEntity blockEntity = this.world.getBlockEntity(secondControllerPos);
            if (!(blockEntity instanceof AcceleratorControllerBlockEntity) || (secondAccelerator = (AcceleratorControllerBlockEntity)blockEntity).getParticle() == null) {
                return false;
            }
            ActiveParticle secondParticle = secondAccelerator.getParticle();
            Vec3 ownVelocity = particle.nextGate.getCenter().subtract(particle.lastGate.getCenter()).normalize().scale((double)particle.velocity);
            Vec3 secondVelocity = secondParticle.nextGate.getCenter().subtract(secondParticle.lastGate.getCenter()).normalize().scale((double)secondParticle.velocity);
            double impactSpeed = ownVelocity.distanceTo(secondVelocity);
            this.entity.onParticleCollided((float)impactSpeed, particle.position, secondControllerPos, secondAccelerator);
            return true;
        }
        activeParticles.put(blockPos, this.pos);
        return false;
    }

    private Vec3i getGateExitDirection(BlockPos lastGate, BlockPos nextGate) {
        BlockPos incomingPath = nextGate.subtract((Vec3i)lastGate);
        boolean incomingStraight = incomingPath.getX() == 0 || incomingPath.getZ() == 0;
        Vec3i incomingDir = new Vec3i(Math.clamp((long)incomingPath.getX(), -1, 1), 0, Math.clamp((long)incomingPath.getZ(), -1, 1));
        BlockState targetState = this.world.getBlockState(nextGate);
        Block targetBlock = targetState.getBlock();
        if (targetBlock.equals(BlockContent.ACCELERATOR_MOTOR) || targetBlock.equals(BlockContent.ACCELERATOR_SENSOR)) {
            return incomingDir;
        }
        if (!targetBlock.equals(BlockContent.ACCELERATOR_RING)) {
            return incomingDir;
        }
        Direction targetFacing = (Direction)targetState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Integer targetBent = (Integer)targetState.getValue((Property)AcceleratorRingBlock.BENT);
        Integer targetRedstone = (Integer)targetState.getValue((Property)AcceleratorRingBlock.REDSTONE_STATE);
        if (targetRedstone == 0 && incomingStraight && Geometry.getBackward(targetFacing).equals((Object)incomingDir)) {
            return Geometry.getBackward(targetFacing);
        }
        if (!incomingStraight) {
            return Geometry.getBackward(targetFacing);
        }
        if (targetBent == 0) {
            return incomingDir;
        }
        if (targetBent == 1) {
            return Geometry.getForward(targetFacing).offset(Geometry.getLeft(targetFacing));
        }
        return Geometry.getForward(targetFacing).offset(Geometry.getRight(targetFacing));
    }

    public static float getMaxGateDist(float speed) {
        return (float)Math.clamp(Math.sqrt(speed) / 2.0, 2.0, (double)Oritech.CONFIG.maxGateDist());
    }

    public static float getRequiredBendDist(float speed) {
        return (float)(Math.sqrt(speed) / (double)Oritech.CONFIG.bendFactor());
    }

    public static float getParticleBendDist(float distA, float distB) {
        float combinedDist = distA + distB;
        float smallerDist = Math.min(distA, distB);
        return combinedDist += smallerDist;
    }

    @Nullable
    private BlockPos findNextGateCached(BlockPos from, Vec3i direction, float speed) {
        BlockPos result;
        int dist;
        float maxDist = AcceleratorParticleLogic.getMaxGateDist(speed);
        CompPair<BlockPos, Vec3i> key = new CompPair<BlockPos, Vec3i>(from, direction);
        if (cachedGates.containsKey(key) && (float)(dist = (int)(result = cachedGates.get(key)).getCenter().distanceTo(from.getCenter())) <= maxDist) {
            return result;
        }
        BlockPos candidate = this.findNextGate(from, direction, speed);
        if (candidate != null) {
            cachedGates.put(key, candidate);
        }
        return candidate;
    }

    @Nullable
    public BlockPos findNextGate(BlockPos from, Vec3i direction, float speed) {
        float maxDist = AcceleratorParticleLogic.getMaxGateDist(speed);
        int i = 1;
        while ((float)i <= maxDist) {
            BlockPos candidatePos = from.offset(direction.multiply(i));
            BlockState candidateState = this.world.getBlockState(candidatePos);
            if (!candidateState.isAir()) {
                boolean isValid;
                if (candidateState.getBlock().equals(BlockContent.ACCELERATOR_MOTOR) || candidateState.getBlock().equals(BlockContent.ACCELERATOR_SENSOR)) {
                    return candidatePos;
                }
                if (!candidateState.getBlock().equals(BlockContent.ACCELERATOR_RING)) {
                    return null;
                }
                Integer candidateBent = (Integer)candidateState.getValue((Property)AcceleratorRingBlock.BENT);
                Direction candidateFacing = (Direction)candidateState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                Integer candidateRedstone = (Integer)candidateState.getValue((Property)AcceleratorRingBlock.REDSTONE_STATE);
                BlockPos candidateBack = candidatePos.offset(Geometry.getBackward(candidateFacing).multiply(i));
                BlockPos candidateFront = candidatePos.offset(Geometry.getForward(candidateFacing).multiply(i));
                if (candidateBent == 1) {
                    candidateFront = candidateFront.offset(Geometry.getLeft(candidateFacing).multiply(i));
                }
                if (candidateBent == 2) {
                    candidateFront = candidateFront.offset(Geometry.getRight(candidateFacing).multiply(i));
                }
                boolean bl = isValid = candidateBack.equals((Object)from) || candidateFront.equals((Object)from);
                if (!isValid && candidateRedstone != 3) {
                    candidateFront = candidatePos.offset(Geometry.getForward(candidateFacing).multiply(i));
                    if (candidateRedstone == 1) {
                        candidateFront = candidateFront.offset(Geometry.getLeft(candidateFacing).multiply(i));
                    } else if (candidateRedstone == 2) {
                        candidateFront = candidateFront.offset(Geometry.getRight(candidateFacing).multiply(i));
                    }
                    isValid = candidateFront.equals((Object)from);
                }
                if (isValid) {
                    return candidatePos;
                }
            }
            ++i;
        }
        return null;
    }

    public static void onTickEnd() {
        activeParticles.clear();
    }

    public static void resetCachedGate(BlockPos pos) {
        List<CompPair> toRemove = cachedGates.entrySet().stream().filter(elem -> ((BlockPos)((CompPair)((Object)((Object)elem.getKey()))).getA()).equals((Object)pos) || ((BlockPos)elem.getValue()).equals((Object)pos)).map(Map.Entry::getKey).toList();
        toRemove.forEach(cachedGates::remove);
    }

    public static void resetNearbyCache(BlockPos pos) {
        List<CompPair> toRemove = cachedGates.keySet().stream().filter(blockPos -> ((BlockPos)blockPos.getA()).distManhattan((Vec3i)pos) < Oritech.CONFIG.maxGateDist() + 1).toList();
        toRemove.forEach(cachedGates::remove);
    }

    public static final class ActiveParticle {
        public Vec3 position;
        public float velocity;
        public BlockPos nextGate;
        public BlockPos lastGate;
        public float lastBendDistance = 15000.0f;
        public float lastBendDistance2 = 15000.0f;

        public ActiveParticle(Vec3 position, float velocity, BlockPos nextGate, BlockPos lastGate) {
            this.position = position;
            this.velocity = velocity;
            this.nextGate = nextGate;
            this.lastGate = lastGate;
        }
    }

    public static final class CompPair<A, B>
    extends Tuple<A, B> {
        public CompPair(A left, B right) {
            super(left, right);
        }

        public int hashCode() {
            return (this.getA() == null ? 0 : this.getA().hashCode()) ^ (this.getB() == null ? 0 : this.getB().hashCode());
        }

        public boolean equals(Object o) {
            if (!(o instanceof CompPair)) {
                return false;
            }
            CompPair p = (CompPair)((Object)o);
            return Objects.equals(p.getA(), this.getA()) && Objects.equals(p.getB(), this.getB());
        }
    }
}

