/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import rearth.oritech.block.blocks.processing.MachineCoreBlock;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.DelegatingFluidStorage;
import rearth.oritech.util.DelegatingItemStorage;
import rearth.oritech.util.FluidProvider;
import rearth.oritech.util.InventoryProvider;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.energy.EnergyApi;
import rearth.oritech.util.energy.containers.DelegatingEnergyStorage;
import rearth.oritech.util.energy.containers.SimpleEnergyStorage;

public class MachineCoreEntity
extends BlockEntity
implements InventoryProvider,
EnergyApi.BlockProvider,
FluidProvider {
    private BlockPos controllerPos = BlockPos.ZERO;
    private MultiblockMachineController controllerEntity;
    private final DelegatingEnergyStorage delegatedEnergy = new DelegatingEnergyStorage(this::getMainEnergyStorage, this::isEnabled);
    private final Map<Direction, DelegatingFluidStorage> delegatedFluid = new HashMap<Direction, DelegatingFluidStorage>(6);
    private final Map<Direction, DelegatingItemStorage> delegatedItem = new HashMap<Direction, DelegatingItemStorage>(6);

    public MachineCoreEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.MACHINE_CORE_ENTITY, pos, state);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt("controller_x", this.controllerPos.getX());
        nbt.putInt("controller_y", this.controllerPos.getY());
        nbt.putInt("controller_z", this.controllerPos.getZ());
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.controllerPos = new BlockPos(nbt.getInt("controller_x"), nbt.getInt("controller_y"), nbt.getInt("controller_z"));
    }

    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
        this.controllerEntity = null;
        this.setChanged();
    }

    public MultiblockMachineController getCachedController() {
        if (!((Boolean)this.getBlockState().getValue((Property)MachineCoreBlock.USED)).booleanValue()) {
            return null;
        }
        if (this.controllerEntity == null || ((BlockEntity)this.controllerEntity).isRemoved()) {
            this.controllerEntity = (MultiblockMachineController)Objects.requireNonNull(this.level).getBlockEntity(this.getControllerPos());
        }
        return this.controllerEntity;
    }

    private EnergyApi.EnergyContainer getMainEnergyStorage() {
        Boolean isUsed = (Boolean)this.getBlockState().getValue((Property)MachineCoreBlock.USED);
        if (!isUsed.booleanValue()) {
            return null;
        }
        MultiblockMachineController controllerEntity = this.getCachedController();
        if (controllerEntity == null) {
            return new SimpleEnergyStorage(100L, 0L, 0L);
        }
        return controllerEntity.getEnergyStorageForLink();
    }

    private Storage<FluidVariant> getMainFluidStorage(Direction direction) {
        Boolean isUsed = (Boolean)this.getBlockState().getValue((Property)MachineCoreBlock.USED);
        if (!isUsed.booleanValue()) {
            return null;
        }
        MultiblockMachineController controllerEntity = this.getCachedController();
        if (!(controllerEntity instanceof FluidProvider)) {
            return null;
        }
        FluidProvider fluidProvider = (FluidProvider)((Object)controllerEntity);
        return fluidProvider.getFluidStorage(direction);
    }

    private Storage<ItemVariant> getMainItemStorage(Direction direction) {
        Boolean isUsed = (Boolean)this.getBlockState().getValue((Property)MachineCoreBlock.USED);
        if (!isUsed.booleanValue()) {
            return null;
        }
        MultiblockMachineController controllerEntity = this.getCachedController();
        if (!(controllerEntity instanceof InventoryProvider)) {
            return null;
        }
        InventoryProvider itemProvider = (InventoryProvider)((Object)controllerEntity);
        return itemProvider.getInventory(direction);
    }

    private Storage<FluidVariant> getFluidStorageDelegated(Direction direction) {
        return this.delegatedFluid.computeIfAbsent(direction, dir -> new DelegatingFluidStorage(() -> this.getMainFluidStorage((Direction)dir), this::isEnabled));
    }

    private Storage<ItemVariant> getItemStorageDelegated(Direction direction) {
        return this.delegatedItem.computeIfAbsent(direction, dir -> new DelegatingItemStorage(() -> this.getMainItemStorage((Direction)dir), this::isEnabled));
    }

    public boolean isEnabled() {
        return (Boolean)this.getBlockState().getValue((Property)MachineCoreBlock.USED);
    }

    @Override
    public EnergyApi.EnergyContainer getStorage(Direction direction) {
        if (this.getCachedController() == null || this.getCachedController().getEnergyStorageForLink() == null) {
            return null;
        }
        return this.delegatedEnergy;
    }

    @Override
    public Storage<ItemVariant> getInventory(Direction direction) {
        return this.getItemStorageDelegated(direction);
    }

    @Override
    public Storage<FluidVariant> getFluidStorage(Direction direction) {
        return this.getFluidStorageDelegated(direction);
    }
}

