/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.storage;

import java.util.List;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.storage.SmallFluidTankEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.util.ComparatorOutputProvider;

public class SmallFluidTank
extends Block
implements EntityBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public SmallFluidTank(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SmallFluidTankEntity(pos, state, false);
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return ((ComparatorOutputProvider)world.getBlockEntity(pos)).getComparatorOutput();
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide) {
            ExtendedScreenHandlerFactory handler = (ExtendedScreenHandlerFactory)world.getBlockEntity(pos);
            player.openMenu((MenuProvider)handler);
        }
        return InteractionResult.SUCCESS;
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List droppedStacks = super.getDrops(state, builder);
        BlockEntity blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof SmallFluidTankEntity) {
            SmallFluidTankEntity tankEntity = (SmallFluidTankEntity)blockEntity;
            droppedStacks.addAll(tankEntity.inventory.getItems());
        }
        return droppedStacks;
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return SmallFluidTank.getStackWithData(world, pos);
    }

    @NotNull
    private static ItemStack getStackWithData(LevelReader world, BlockPos pos) {
        SmallFluidTankEntity tankEntity = (SmallFluidTankEntity)world.getBlockEntity(pos);
        ItemStack stack = SmallFluidTank.getBasePickStack(tankEntity.isCreative);
        if (tankEntity.getForDirectFluidAccess().amount > 0L) {
            CompoundTag nbt = new CompoundTag();
            tankEntity.saveAdditional(nbt, (HolderLookup.Provider)world.registryAccess());
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
            Component fluidName = FluidVariantAttributes.getName((FluidVariant)((FluidVariant)tankEntity.getForDirectFluidAccess().variant));
            stack.set(DataComponents.CUSTOM_NAME, (Object)fluidName.copy().append(" ").append((Component)Component.translatable((String)(tankEntity.isCreative ? "block.oritech.creative_tank_block" : "block.oritech.small_tank_block"))));
        }
        return stack;
    }

    public static ItemStack getBasePickStack(boolean creative) {
        return new ItemStack((ItemLike)(creative ? BlockContent.CREATIVE_TANK_BLOCK.asItem() : BlockContent.SMALL_TANK_BLOCK.asItem()));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        if (!itemStack.has(DataComponents.CUSTOM_DATA)) {
            return;
        }
        SmallFluidTankEntity tankEntity = (SmallFluidTankEntity)world.getBlockEntity(pos);
        CompoundTag nbt = ((CustomData)itemStack.get(DataComponents.CUSTOM_DATA)).copyTag();
        if (nbt != null) {
            tankEntity.loadAdditional(nbt, (HolderLookup.Provider)world.registryAccess());
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof BlockEntityTicker) {
                BlockEntityTicker ticker = (BlockEntityTicker)blockEntity;
                ticker.tick(world1, pos, state1, blockEntity);
            }
        };
    }
}

