/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.storage;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.base.entity.ExpandableEnergyStorageBlockEntity;
import rearth.oritech.block.blocks.storage.SmallStorageBlock;
import rearth.oritech.block.entity.storage.LargeStorageBlockEntity;
import rearth.oritech.util.MultiblockMachineController;

public class LargeStorageBlock
extends SmallStorageBlock {
    public LargeStorageBlock(BlockBehaviour.Properties settings) {
        super(settings.lightLevel(value -> 2));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)MultiblockMachine.ASSEMBLED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{MultiblockMachine.ASSEMBLED});
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new LargeStorageBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(ctx)).setValue((Property)TARGET_DIR, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    @Override
    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide) {
            Boolean corePlaced;
            BlockEntity entity = world.getBlockEntity(pos);
            if (!(entity instanceof MultiblockMachineController)) {
                return InteractionResult.SUCCESS;
            }
            MultiblockMachineController machineEntity = (MultiblockMachineController)entity;
            Boolean wasAssembled = (Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED);
            if (!wasAssembled.booleanValue() && (corePlaced = machineEntity.tryPlaceNextCore(player)).booleanValue()) {
                return InteractionResult.SUCCESS;
            }
            boolean isAssembled = machineEntity.initMultiblock(state);
            if (isAssembled && !wasAssembled.booleanValue()) {
                return InteractionResult.SUCCESS;
            }
            if (!isAssembled) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.oritech.machine.missing_core"));
                return InteractionResult.SUCCESS;
            }
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    @Override
    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide() && ((Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED)).booleanValue()) {
            BlockEntity entity = world.getBlockEntity(pos);
            if (entity instanceof MultiblockMachineController) {
                MultiblockMachineController machineEntity = (MultiblockMachineController)entity;
                machineEntity.onControllerBroken();
            }
            if (entity instanceof ExpandableEnergyStorageBlockEntity) {
                ExpandableEnergyStorageBlockEntity storageBlock = (ExpandableEnergyStorageBlockEntity)entity;
                NonNullList stacks = storageBlock.inventory.items;
                for (ItemStack heldStack : stacks) {
                    if (heldStack.isEmpty()) continue;
                    ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), heldStack);
                    world.addFreshEntity((Entity)itemEntity);
                }
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }
}

