/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.processing;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.block.entity.interaction.DeepDrillEntity;
import rearth.oritech.util.MultiblockMachineController;

public class MachineCoreBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty USED = BooleanProperty.create((String)"core_used");
    private final float coreQuality;

    public MachineCoreBlock(BlockBehaviour.Properties settings, float coreQuality) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)USED, (Comparable)Boolean.valueOf(false)));
        this.coreQuality = coreQuality;
    }

    public float getCoreQuality() {
        return this.coreQuality;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{USED});
    }

    public RenderShape getRenderShape(BlockState state) {
        return (Boolean)state.getValue((Property)USED) != false ? RenderShape.INVISIBLE : RenderShape.MODEL;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide() && ((Boolean)state.getValue((Property)USED)).booleanValue()) {
            BlockEntity controllerEntity = MachineCoreBlock.getControllerEntity(world, pos);
            if (controllerEntity == null) {
                return state;
            }
            if (controllerEntity instanceof MultiblockMachineController) {
                MultiblockMachineController machineEntity = (MultiblockMachineController)controllerEntity;
                machineEntity.onCoreBroken(pos);
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    @NotNull
    public static BlockPos getControllerPos(Level world, BlockPos pos) {
        MachineCoreEntity coreEntity = (MachineCoreEntity)world.getBlockEntity(pos);
        return Objects.requireNonNull(coreEntity).getControllerPos();
    }

    @Nullable
    public static BlockEntity getControllerEntity(Level world, BlockPos pos) {
        return world.getBlockEntity(MachineCoreBlock.getControllerPos(world, pos));
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!((Boolean)state.getValue((Property)USED)).booleanValue()) {
            return InteractionResult.PASS;
        }
        if (!world.isClientSide) {
            DeepDrillEntity deepDrill;
            BlockPos controllerPos = MachineCoreBlock.getControllerPos(world, pos);
            BlockState controllerBlock = world.getBlockState(controllerPos);
            BlockEntity controllerEntity = world.getBlockEntity(controllerPos);
            if (controllerEntity instanceof DeepDrillEntity && !(deepDrill = (DeepDrillEntity)controllerEntity).init(true)) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.oritech.deep_drill.ore_placement"));
                return InteractionResult.SUCCESS;
            }
            return controllerBlock.getBlock().useWithoutItem(controllerBlock, world, controllerPos, player, hit);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MachineCoreEntity(pos, state);
    }
}

