/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.pipes.item;

import java.util.HashMap;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.function.TriFunction;
import rearth.oritech.block.blocks.pipes.GenericPipeBlock;
import rearth.oritech.block.blocks.pipes.item.ItemPipeConnectionBlock;
import rearth.oritech.block.blocks.pipes.item.ItemPipeDuctBlock;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.BlockContent;

public class ItemPipeBlock
extends GenericPipeBlock {
    public static HashMap<ResourceLocation, GenericPipeInterfaceEntity.PipeNetworkData> ITEM_PIPE_DATA = new HashMap();

    public ItemPipeBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public TriFunction<Level, BlockPos, Direction, Boolean> apiValidationFunction() {
        return (world, pos, direction) -> ItemStorage.SIDED.find(world, pos, direction) != null;
    }

    @Override
    public BlockState getConnectionBlock() {
        return BlockContent.ITEM_PIPE_CONNECTION.defaultBlockState();
    }

    @Override
    public BlockState getNormalBlock() {
        return BlockContent.ITEM_PIPE.defaultBlockState();
    }

    @Override
    protected VoxelShape[] createShapes() {
        VoxelShape inner = Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
        VoxelShape north = Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
        VoxelShape east = Block.box((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
        VoxelShape south = Block.box((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
        VoxelShape west = Block.box((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
        VoxelShape up = Block.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        VoxelShape down = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
        return new VoxelShape[]{inner, north, west, south, east, up, down};
    }

    @Override
    public String getPipeTypeName() {
        return "item";
    }

    @Override
    public boolean connectToOwnBlockType(Block block) {
        return block instanceof ItemPipeBlock || block instanceof ItemPipeConnectionBlock || block instanceof ItemPipeDuctBlock;
    }

    @Override
    public GenericPipeInterfaceEntity.PipeNetworkData getNetworkData(Level world) {
        return ITEM_PIPE_DATA.computeIfAbsent(world.dimension().location(), data -> new GenericPipeInterfaceEntity.PipeNetworkData());
    }

    public static class FramedItemPipeBlock
    extends ItemPipeBlock {
        public FramedItemPipeBlock(BlockBehaviour.Properties settings) {
            super(settings);
        }

        @Override
        public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            return Shapes.block();
        }

        @Override
        public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            return state.getShape(world, pos);
        }

        @Override
        public BlockState getNormalBlock() {
            return BlockContent.FRAMED_ITEM_PIPE.defaultBlockState();
        }

        @Override
        public BlockState getConnectionBlock() {
            return BlockContent.FRAMED_ITEM_PIPE_CONNECTION.defaultBlockState();
        }
    }
}

