/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.decorative;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.init.BlockContent;

public class MetalBeamBlock
extends Block {
    private static final IntegerProperty BEAM_STATE = IntegerProperty.create((String)"beam", (int)0, (int)2);
    private static final VoxelShape BEAM_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public MetalBeamBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BEAM_STATE, (Comparable)Integer.valueOf(0)));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BEAM_STATE});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return BEAM_SHAPE;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return BEAM_SHAPE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        return this.getTargetState((LevelAccessor)world, pos);
    }

    private BlockState getTargetState(LevelAccessor world, BlockPos pos) {
        boolean beamBelow = world.getBlockState(pos.below()).getBlock().equals(BlockContent.METAL_BEAM_BLOCK);
        boolean beamAbove = world.getBlockState(pos.above()).getBlock().equals(BlockContent.METAL_BEAM_BLOCK);
        BlockState state = this.defaultBlockState();
        if (beamBelow && beamAbove) {
            return (BlockState)state.setValue((Property)BEAM_STATE, (Comparable)Integer.valueOf(1));
        }
        if (beamBelow) {
            return (BlockState)state.setValue((Property)BEAM_STATE, (Comparable)Integer.valueOf(2));
        }
        return (BlockState)state.setValue((Property)BEAM_STATE, (Comparable)Integer.valueOf(0));
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return this.getTargetState(world, pos);
    }
}

