/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.augmenter;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.OritechClient;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.entity.augmenter.AugmentApplicationEntity;
import rearth.oritech.client.ui.PlayerModifierScreenHandler;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.TooltipHelper;

public class AugmentApplicationBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    private final VoxelShape[] HITBOXES = this.computeShapes();
    private final HashMap<Player, Long> lastContact = new HashMap();

    public AugmentApplicationBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)MultiblockMachine.ASSEMBLED, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (!((Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED)).booleanValue()) {
            return super.getShape(state, world, pos, context);
        }
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return this.HITBOXES[facing.ordinal()];
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, MultiblockMachine.ASSEMBLED});
    }

    private VoxelShape[] computeShapes() {
        VoxelShape[] result = new VoxelShape[6];
        for (Direction facing : BlockStateProperties.HORIZONTAL_FACING.getPossibleValues()) {
            result[facing.ordinal()] = Shapes.or((VoxelShape)Geometry.rotateVoxelShape(Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0), facing, AttachFace.FLOOR), (VoxelShape)Geometry.rotateVoxelShape(Shapes.box((double)0.0, (double)0.1875, (double)0.875, (double)1.0, (double)1.0, (double)1.0), facing, AttachFace.FLOOR));
        }
        return result;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(ctx)).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    protected void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (world.isClientSide || !((Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED)).booleanValue()) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Vec3 centerPos = pos.getBottomCenter().add(0.0, 0.2, 0.0);
        double dist = entity.position().distanceTo(centerPos);
        if (dist < 0.45) {
            boolean locked;
            long ageWithoutContact = world.getGameTime() - this.lastContact.getOrDefault(player, 0L);
            long time = world.getGameTime();
            this.lastContact.put(player, time);
            if (ageWithoutContact > 15L && (locked = this.lockPlayer(player, centerPos, state))) {
                AugmentApplicationEntity blockEntity = (AugmentApplicationEntity)world.getBlockEntity(pos);
                blockEntity.loadAvailableStations(player);
                player.openMenu((MenuProvider)blockEntity);
            }
        }
    }

    private boolean lockPlayer(Player player, Vec3 lockPos, BlockState state) {
        double maxVelocity = Math.max(Math.max(Math.abs(player.getDeltaMovement().x), Math.abs(player.getDeltaMovement().y)), Math.abs(player.getDeltaMovement().z));
        if (maxVelocity < 0.01 || player.containerMenu instanceof PlayerModifierScreenHandler) {
            return false;
        }
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        int rotation = switch (facing) {
            case Direction.NORTH -> 180;
            case Direction.WEST -> 90;
            case Direction.EAST -> -90;
            default -> 0;
        };
        player.setDeltaMovement(Vec3.ZERO);
        player.teleportTo((ServerLevel)player.level(), lockPos.x, lockPos.y, lockPos.z, Set.of(), (float)rotation, 0.0f);
        double dist = player.position().distanceTo(lockPos);
        return dist < 0.1;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        Boolean corePlaced;
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity entity = world.getBlockEntity(pos);
        if (!(entity instanceof AugmentApplicationEntity)) {
            return InteractionResult.SUCCESS;
        }
        AugmentApplicationEntity modifierEntity = (AugmentApplicationEntity)entity;
        Boolean wasAssembled = (Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED);
        if (!wasAssembled.booleanValue() && (corePlaced = modifierEntity.tryPlaceNextCore(player)).booleanValue()) {
            return InteractionResult.SUCCESS;
        }
        boolean isAssembled = modifierEntity.initMultiblock(state);
        if (isAssembled && !wasAssembled.booleanValue()) {
            NetworkContent.MACHINE_CHANNEL.serverHandle(entity).send((Record)new NetworkContent.MachineSetupEventPacket(pos));
            return InteractionResult.SUCCESS;
        }
        if (!isAssembled) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.oritech.machine.missing_core"));
            return InteractionResult.SUCCESS;
        }
        AugmentApplicationEntity blockEntity = (AugmentApplicationEntity)world.getBlockEntity(pos);
        blockEntity.loadAvailableStations(player);
        player.openMenu((MenuProvider)blockEntity);
        return InteractionResult.SUCCESS;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity entity;
        if (!world.isClientSide() && (entity = world.getBlockEntity(pos)) instanceof AugmentApplicationEntity) {
            AugmentApplicationEntity storageBlock = (AugmentApplicationEntity)entity;
            storageBlock.onControllerBroken();
            NonNullList stacks = storageBlock.inventory.items;
            for (ItemStack heldStack : stacks) {
                if (heldStack.isEmpty()) continue;
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), heldStack);
                world.addFreshEntity((Entity)itemEntity);
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AugmentApplicationEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof BlockEntityTicker) {
                BlockEntityTicker ticker = (BlockEntityTicker)blockEntity;
                ticker.tick(world1, pos, state1, blockEntity);
            }
        };
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        super.appendHoverText(stack, context, tooltip, options);
        Component hotkey = OritechClient.AUGMENT_SELECTOR.key.getDisplayName();
        tooltip.add((Component)Component.translatable((String)"tooltip.oritech.augmenter.1").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"tooltip.oritech.augmenter.2", (Object[])new Object[]{hotkey.tryCollapseToString()}).withStyle(ChatFormatting.GRAY));
        TooltipHelper.addMachineTooltip(tooltip, (Block)this, this);
    }
}

