/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.behavior;

import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import rearth.oritech.block.blocks.interaction.LaserArmBlock;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.util.energy.EnergyApi;
import rearth.oritech.util.energy.SingleSlotHandler;

public class LaserArmEntityBehavior {
    private static LaserArmEntityBehavior transferPowerBehavior;
    private static LaserArmEntityBehavior chargeEntityBehavior;

    public boolean fireAtEntity(Level world, LaserArmBlockEntity laserEntity, LivingEntity entity) {
        if (laserEntity.hasCropFilterAddon && entity instanceof Animal && entity.isBaby()) {
            return false;
        }
        entity.hurt(new DamageSource((Holder)world.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.MAGIC), (Entity)laserEntity.getLaserPlayerEntity()), laserEntity.getDamageTick());
        return true;
    }

    public static void registerDefaults() {
        transferPowerBehavior = new LaserArmEntityBehavior(){

            @Override
            public boolean fireAtEntity(Level world, LaserArmBlockEntity laserEntity, LivingEntity entity) {
                if (!(entity instanceof Player)) {
                    return false;
                }
                Player player = (Player)entity;
                ItemStack chestItem = player.getItemBySlot(EquipmentSlot.CHEST);
                EnergyApi.EnergyContainer candidate = EnergyApi.ITEM.find(chestItem, ContainerItemContext.ofSingleSlot((SingleSlotStorage)new SingleSlotHandler(chestItem)));
                if (candidate != null) {
                    Long amount = EnergyApi.transfer(laserEntity.getEnergyStorageForLink(), candidate, laserEntity.energyRequiredToFire(), false);
                    return amount > 0L;
                }
                return false;
            }
        };
        LaserArmBlock.registerEntityBehavior(EntityType.PLAYER, transferPowerBehavior);
        chargeEntityBehavior = new LaserArmEntityBehavior(){

            @Override
            public boolean fireAtEntity(Level world, LaserArmBlockEntity laserEntity, LivingEntity entity) {
                entity.getEntityData().set(Creeper.DATA_IS_POWERED, (Object)true);
                return super.fireAtEntity(world, laserEntity, entity);
            }
        };
        LaserArmBlock.registerEntityBehavior(EntityType.CREEPER, chargeEntityBehavior);
    }
}

