/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.energy.containers.DynamicEnergyStorage;

public abstract class UpgradableMachineBlockEntity
extends MachineBlockEntity
implements MachineAddonController {
    private final List<BlockPos> connectedAddons = new ArrayList<BlockPos>();
    private final List<BlockPos> openSlots = new ArrayList<BlockPos>();
    private MachineAddonController.BaseAddonData addonData = MachineAddonController.DEFAULT_ADDON_DATA;

    public UpgradableMachineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int energyPerTick) {
        super(type, pos, state, energyPerTick);
    }

    @Override
    protected void craftItem(OritechRecipe activeRecipe, List<ItemStack> outputInventory, List<ItemStack> inputInventory) {
        super.craftItem(activeRecipe, outputInventory, inputInventory);
        if (this.supportExtraChambersAuto()) {
            int chamberCount = this.addonData.extraChambers();
            for (int i = 0; i < chamberCount && this.canOutputRecipe(activeRecipe) && this.canProceed(activeRecipe); ++i) {
                super.craftItem(activeRecipe, outputInventory, inputInventory);
            }
        }
    }

    public boolean supportExtraChambersAuto() {
        return true;
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        this.writeAddonToNbt(nbt);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.loadAddonNbtData(nbt);
        this.updateEnergyContainer();
    }

    @Override
    public List<BlockPos> getConnectedAddons() {
        return this.connectedAddons;
    }

    @Override
    public List<BlockPos> getOpenSlots() {
        return this.openSlots;
    }

    @Override
    public Direction getFacingForAddon() {
        return super.getFacing();
    }

    @Override
    public DynamicEnergyStorage getStorageForAddon() {
        return super.getEnergyStorage();
    }

    @Override
    public MachineAddonController.BaseAddonData getBaseAddonData() {
        return this.addonData;
    }

    @Override
    public BlockPos getMachinePos() {
        return this.getBlockPos();
    }

    @Override
    public Level getMachineWorld() {
        return this.getLevel();
    }

    @Override
    public void setBaseAddonData(MachineAddonController.BaseAddonData data) {
        this.addonData = data;
        this.setChanged();
    }

    @Override
    public Object getScreenOpeningData(ServerPlayer player) {
        this.sendNetworkEntry();
        return new ModScreens.UpgradableData(this.worldPosition, this.getUiData(), this.getCoreQuality());
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new UpgradableMachineScreenHandler(syncId, playerInventory, this, this.getUiData(), this.getCoreQuality());
    }

    @Override
    public SimpleContainer getInventoryForAddon() {
        return this.inventory;
    }

    @Override
    public ScreenProvider getScreenProvider() {
        return this;
    }

    @Override
    public float getSpeedMultiplier() {
        return this.getBaseAddonData().speed();
    }

    @Override
    public float getEfficiencyMultiplier() {
        return this.getBaseAddonData().efficiency();
    }

    @Override
    public int receivedRedstoneSignal() {
        if (this.disabledViaRedstone) {
            return 15;
        }
        return 0;
    }

    @Override
    public String currentRedstoneEffect() {
        if (this.disabledViaRedstone) {
            return "tooltip.oritech.redstone_disabled";
        }
        return "tooltip.oritech.redstone_enabled";
    }
}

