/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.FilteringStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.base.entity.UpgradableMachineBlockEntity;
import rearth.oritech.block.entity.processing.CentrifugeBlockEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.FluidContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.energy.EnergyApi;

public abstract class UpgradableGeneratorBlockEntity
extends UpgradableMachineBlockEntity {
    public int currentMaxBurnTime;
    private List<ItemStack> pendingOutputs = new ArrayList<ItemStack>();
    public boolean isProducingSteam = false;
    public final SingleVariantStorage<FluidVariant> waterStorage = this.createBasicTank(FluidVariant.of((Fluid)Fluids.WATER));
    public final SingleVariantStorage<FluidVariant> steamStorage = this.createBasicTank(FluidVariant.of((Fluid)((Fluid)FluidContent.STILL_STEAM.get())));
    public final Storage<FluidVariant> waterWrapper = FilteringStorage.insertOnlyOf(this.waterStorage);
    public final Storage<FluidVariant> steamWrapper = FilteringStorage.extractOnlyOf(this.steamStorage);
    public final Storage<FluidVariant> exposedStorage = new CombinedStorage(List.of(this.steamWrapper, this.waterWrapper));

    public UpgradableGeneratorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int energyPerTick) {
        super(type, pos, state, energyPerTick);
    }

    @Override
    public void tick(Level world, BlockPos pos, BlockState state, MachineBlockEntity blockEntity) {
        if (world.isClientSide || !this.isActive(state) || this.disabledViaRedstone) {
            return;
        }
        if (this.progress > 0) {
            if (this.canFitEnergy()) {
                --this.progress;
                this.produceEnergy();
                this.lastWorkedAt = world.getGameTime();
                if (this.progress == 0) {
                    this.burningFinished();
                }
                this.setChanged();
                this.markNetDirty();
            }
        } else if (this.canFitEnergy()) {
            this.tryConsumeInput();
        }
        if (this.networkDirty) {
            this.updateNetwork();
        }
        this.outputEnergy();
    }

    protected void tryConsumeInput() {
        if (this.isProducingSteam && (this.waterStorage.amount == 0L || this.steamStorage.amount == this.steamStorage.getCapacity())) {
            return;
        }
        Optional<RecipeHolder<OritechRecipe>> recipeCandidate = this.getRecipe();
        if (recipeCandidate.isEmpty()) {
            this.currentRecipe = OritechRecipe.DUMMY;
        }
        if (recipeCandidate.isPresent()) {
            int recipeTime;
            OritechRecipe activeRecipe;
            this.currentRecipe = activeRecipe = (OritechRecipe)recipeCandidate.get().value();
            this.progress = recipeTime = (int)((float)this.currentRecipe.getTime() * this.getSpeedMultiplier() * (1.0f / this.getEfficiencyMultiplier()));
            this.currentMaxBurnTime = recipeTime;
            for (int i = 0; i < activeRecipe.getInputs().size(); ++i) {
                ItemStack itemStack = ContainerHelper.removeItem(this.getInputView(), (int)i, (int)1);
            }
            this.pendingOutputs = activeRecipe.getResults();
            this.markNetDirty();
            this.setChanged();
        }
    }

    protected void burningFinished() {
        this.produceResultItems();
    }

    protected void produceResultItems() {
        if (!this.pendingOutputs.isEmpty()) {
            for (ItemStack stack : this.pendingOutputs) {
                this.inventory.addItem(stack);
            }
        }
        this.pendingOutputs.clear();
    }

    @Override
    public void gatherAddonStats(List<MachineAddonController.AddonBlock> addons) {
        this.isProducingSteam = false;
        super.gatherAddonStats(addons);
    }

    @Override
    public void getAdditionalStatFromAddon(MachineAddonController.AddonBlock addonBlock) {
        super.getAdditionalStatFromAddon(addonBlock);
        if (addonBlock.state().getBlock() == BlockContent.STEAM_BOILER_ADDON) {
            this.isProducingSteam = true;
            this.level.updateNeighborsAt(addonBlock.pos(), addonBlock.state().getBlock());
        }
    }

    @Override
    public void updateEnergyContainer() {
        super.updateEnergyContainer();
        long insert = this.energyStorage.maxInsert;
        this.energyStorage.maxExtract = this.getDefaultExtractionRate() + insert;
        this.energyStorage.maxInsert = 0L;
    }

    protected boolean canFitEnergy() {
        if (this.isProducingSteam) {
            return true;
        }
        float produced = this.calculateEnergyUsage();
        return (float)this.energyStorage.capacity >= (float)this.energyStorage.amount + produced;
    }

    protected void produceEnergy() {
        float produced = this.calculateEnergyUsage();
        if (this.isProducingSteam) {
            produced *= Oritech.CONFIG.generators.rfToSteamRation();
            produced = Math.min((float)this.waterStorage.amount, produced);
            this.steamStorage.amount = (long)((float)this.steamStorage.amount + produced);
            this.steamStorage.amount = Math.min(this.steamStorage.amount, this.steamStorage.getCapacity());
            this.waterStorage.amount = (long)((float)this.waterStorage.amount - produced);
        } else {
            this.energyStorage.amount = (long)((float)this.energyStorage.amount + produced);
        }
    }

    @Override
    protected float calculateEnergyUsage() {
        return (float)this.energyPerTick * (1.0f / this.getSpeedMultiplier());
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt("storedBurn", this.currentMaxBurnTime);
        nbt.putLong("waterStored", this.waterStorage.amount);
        nbt.putLong("steamStored", this.steamStorage.amount);
        nbt.putBoolean("steamAddon", this.isProducingSteam);
        ListTag resList = new ListTag();
        for (ItemStack stack : this.pendingOutputs) {
            Tag data = stack.save(registryLookup);
            resList.add((Object)data);
        }
        nbt.put("pendingResults", (Tag)resList);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.currentMaxBurnTime = nbt.getInt("storedBurn");
        this.steamStorage.amount = nbt.getLong("steamStored");
        this.waterStorage.amount = nbt.getLong("waterStored");
        this.isProducingSteam = nbt.getBoolean("steamAddon");
        ListTag storedResults = nbt.getList("pendingResults", 10);
        for (Tag elem : storedResults) {
            CompoundTag compound = (CompoundTag)elem;
            ItemStack stack = (ItemStack)ItemStack.parse((HolderLookup.Provider)registryLookup, (Tag)compound).get();
            this.pendingOutputs.add(stack);
        }
    }

    @Override
    protected void sendNetworkEntry() {
        super.sendNetworkEntry();
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.GeneratorUISyncPacket(this.getBlockPos(), this.currentMaxBurnTime, this.isProducingSteam));
        if (this.isProducingSteam) {
            NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.GeneratorSteamSyncPacket(this.worldPosition, this.steamStorage.amount, this.waterStorage.amount));
        }
    }

    protected abstract Set<Tuple<BlockPos, Direction>> getOutputTargets(BlockPos var1, Level var2);

    protected void outputEnergy() {
        if (this.energyStorage.getAmount() <= 0L) {
            return;
        }
        for (Tuple<BlockPos, Direction> target : this.getOutputTargets(this.worldPosition, this.level)) {
            EnergyApi.EnergyContainer candidate = EnergyApi.BLOCK.find(this.level, (BlockPos)target.getA(), (Direction)target.getB());
            if (candidate == null) continue;
            EnergyApi.transfer(this.energyStorage, candidate, Long.MAX_VALUE, false);
        }
    }

    @Override
    public float getProgress() {
        return 1.0f - (float)this.progress / (float)this.currentMaxBurnTime;
    }

    public int getCurrentMaxBurnTime() {
        return this.currentMaxBurnTime;
    }

    public void setCurrentMaxBurnTime(int currentMaxBurnTime) {
        this.currentMaxBurnTime = currentMaxBurnTime;
    }

    @Override
    public long getDefaultInsertRate() {
        return 0L;
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return this.energyStorage.maxExtract;
    }

    @Override
    public boolean showEnergy() {
        if (this.energyStorage.maxExtract <= 0L && !this.isProducingSteam) {
            return false;
        }
        return super.showEnergy();
    }

    @Override
    protected float getAnimationSpeed() {
        if (this.currentMaxBurnTime <= 0) {
            return 1.0f;
        }
        int recipeTicks = this.currentMaxBurnTime;
        float animationTicks = 60.0f;
        return animationTicks / (float)recipeTicks * Oritech.CONFIG.generators.animationSpeedMultiplier();
    }

    public SingleVariantStorage<FluidVariant> getSteamStorage() {
        return this.steamStorage;
    }

    public SingleVariantStorage<FluidVariant> getWaterStorage() {
        return this.waterStorage;
    }

    private SingleVariantStorage<FluidVariant> createBasicTank(final FluidVariant fluidType) {
        return new SingleVariantStorage<FluidVariant>(this){
            final /* synthetic */ UpgradableGeneratorBlockEntity this$0;
            {
                this.this$0 = this$0;
            }

            protected FluidVariant getBlankVariant() {
                return fluidType;
            }

            protected boolean canInsert(FluidVariant variant) {
                return variant.equals((Object)fluidType);
            }

            protected long getCapacity(FluidVariant variant) {
                return CentrifugeBlockEntity.CAPACITY;
            }

            protected void onFinalCommit() {
                super.onFinalCommit();
                this.this$0.setChanged();
            }
        };
    }
}

