/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.addons.RedstoneAddonBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventoryProvider;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.SimpleCraftingInventory;
import rearth.oritech.util.SimpleSidedInventory;
import rearth.oritech.util.energy.EnergyApi;
import rearth.oritech.util.energy.containers.DynamicEnergyStorage;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class MachineBlockEntity
extends BlockEntity
implements ExtendedScreenHandlerFactory,
GeoBlockEntity,
EnergyApi.BlockProvider,
ScreenProvider,
InventoryProvider,
BlockEntityTicker<MachineBlockEntity>,
RedstoneAddonBlockEntity.RedstoneControllable {
    public static final RawAnimation PACKAGED = RawAnimation.begin().thenPlayAndHold("packaged");
    public static final RawAnimation SETUP = RawAnimation.begin().thenPlay("deploy");
    public static final RawAnimation IDLE = RawAnimation.begin().thenPlayAndHold("idle");
    public static final RawAnimation WORKING = RawAnimation.begin().thenLoop("working");
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final SimpleContainer inventory = new SimpleMachineInventory(this.getInventorySize());
    public int progress;
    protected int energyPerTick;
    protected OritechRecipe currentRecipe = OritechRecipe.DUMMY;
    protected InventoryInputMode inventoryInputMode = InventoryInputMode.FILL_LEFT_TO_RIGHT;
    protected boolean disabledViaRedstone = false;
    public long lastWorkedAt;
    protected boolean networkDirty = true;
    public final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(this.getDefaultCapacity(), this.getDefaultInsertRate(), this.getDefaultExtractionRate(), this::setChanged);

    public MachineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int energyPerTick) {
        super(type, pos, state);
        this.energyPerTick = energyPerTick;
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
        if (this.level != null) {
            this.lastWorkedAt = this.level.getGameTime();
        }
    }

    public void tick(Level world, BlockPos pos, BlockState state, MachineBlockEntity blockEntity) {
        if (world.isClientSide || !this.isActive(state) || this.disabledViaRedstone) {
            return;
        }
        Optional<RecipeHolder<OritechRecipe>> recipeCandidate = this.getRecipe();
        if (recipeCandidate.isEmpty()) {
            this.currentRecipe = OritechRecipe.DUMMY;
        }
        if (recipeCandidate.isPresent() && this.canOutputRecipe((OritechRecipe)recipeCandidate.get().value()) && this.canProceed((OritechRecipe)recipeCandidate.get().value())) {
            if (this.currentRecipe != recipeCandidate.get().value()) {
                this.resetProgress();
            }
            if (this.hasEnoughEnergy()) {
                OritechRecipe activeRecipe;
                this.currentRecipe = activeRecipe = (OritechRecipe)recipeCandidate.get().value();
                this.lastWorkedAt = world.getGameTime();
                this.useEnergy();
                ++this.progress;
                if (this.checkCraftingFinished(activeRecipe)) {
                    this.craftItem(activeRecipe, this.getOutputView(), this.getInputView());
                    this.resetProgress();
                }
                this.markNetDirty();
                this.setChanged();
            }
        } else if (this.progress > 0) {
            this.resetProgress();
        }
        if (this.networkDirty) {
            this.updateNetwork();
        }
    }

    protected boolean canProceed(OritechRecipe value) {
        RecipeInput inputInv = this.getInputInventory();
        for (int i = 0; i < value.getInputs().size(); ++i) {
            Ingredient input = value.getInputs().get(i);
            if (input.test(inputInv.getItem(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean hasEnoughEnergy() {
        return (float)this.energyStorage.amount >= this.calculateEnergyUsage();
    }

    protected void useEnergy() {
        this.energyStorage.amount = (long)((float)this.energyStorage.amount - this.calculateEnergyUsage());
    }

    protected float calculateEnergyUsage() {
        return (float)this.energyPerTick * this.getEfficiencyMultiplier() * (1.0f / this.getSpeedMultiplier());
    }

    protected void updateNetwork() {
        if (!this.networkDirty) {
            return;
        }
        int updateFrequency = 5;
        if (this.isActivelyViewed()) {
            updateFrequency = 1;
        }
        if (Objects.requireNonNull(this.level).getGameTime() % (long)updateFrequency != 0L) {
            return;
        }
        this.sendNetworkEntry();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isActivelyViewed() {
        Player closestPlayer = Objects.requireNonNull(this.level).getNearestPlayer((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), 5.0, false);
        if (closestPlayer == null) return false;
        AbstractContainerMenu abstractContainerMenu = closestPlayer.containerMenu;
        if (!(abstractContainerMenu instanceof BasicMachineScreenHandler)) return false;
        BasicMachineScreenHandler handler = (BasicMachineScreenHandler)abstractContainerMenu;
        if (!this.getBlockPos().equals((Object)handler.getBlockPos())) return false;
        return true;
    }

    protected void sendNetworkEntry() {
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.MachineSyncPacket(this.getBlockPos(), this.energyStorage.amount, this.energyStorage.capacity, this.energyStorage.maxInsert, this.energyStorage.maxExtract, this.progress, this.currentRecipe, this.inventoryInputMode, this.lastWorkedAt, this.disabledViaRedstone));
        this.networkDirty = false;
    }

    public void handleNetworkEntry(NetworkContent.MachineSyncPacket message) {
        this.setProgress(message.progress());
        this.setEnergyStored(message.energy());
        this.energyStorage.maxInsert = message.maxInsert();
        this.energyStorage.maxExtract = message.maxExtract();
        this.energyStorage.capacity = message.maxEnergy();
        this.setCurrentRecipe(message.activeRecipe());
        this.setInventoryInputMode(message.inputMode());
        this.lastWorkedAt = message.lastWorkedAt();
        this.disabledViaRedstone = message.disabledViaRedstone();
    }

    public List<ItemStack> getCraftingResults(OritechRecipe activeRecipe) {
        return activeRecipe.getResults();
    }

    protected void craftItem(OritechRecipe activeRecipe, List<ItemStack> outputInventory, List<ItemStack> inputInventory) {
        int i;
        List<ItemStack> results = this.getCraftingResults(activeRecipe);
        List<Ingredient> inputs = activeRecipe.getInputs();
        for (i = 0; i < results.size(); ++i) {
            ItemStack result = results.get(i);
            ItemStack slot = outputInventory.get(i);
            int newCount = slot.getCount() + result.getCount();
            if (slot.isEmpty()) {
                outputInventory.set(i, result.copy());
                continue;
            }
            slot.setCount(newCount);
        }
        for (i = 0; i < inputs.size(); ++i) {
            ContainerHelper.removeItem(inputInventory, (int)i, (int)1);
        }
    }

    private boolean checkCraftingFinished(OritechRecipe activeRecipe) {
        return (float)this.progress >= (float)activeRecipe.getTime() * this.getSpeedMultiplier();
    }

    protected void resetProgress() {
        this.progress = 0;
        this.markNetDirty();
    }

    public void markNetDirty() {
        this.networkDirty = true;
    }

    public boolean canOutputRecipe(OritechRecipe recipe) {
        Container outInv = this.getOutputInventory();
        if (outInv.isEmpty()) {
            return true;
        }
        List<ItemStack> results = recipe.getResults();
        for (int i = 0; i < results.size(); ++i) {
            ItemStack result = results.get(i);
            ItemStack outSlot = outInv.getItem(i);
            if (outSlot.isEmpty() || this.canAddToSlot(result, outSlot)) continue;
            return false;
        }
        return true;
    }

    protected boolean canAddToSlot(ItemStack input, ItemStack slot) {
        if (slot.isEmpty()) {
            return true;
        }
        if (!slot.getItem().equals(input.getItem())) {
            return false;
        }
        return slot.getCount() + input.getCount() <= slot.getMaxStackSize();
    }

    protected Optional<RecipeHolder<OritechRecipe>> getRecipe() {
        return this.level.getRecipeManager().getRecipeFor((RecipeType)this.getOwnRecipeType(), this.getInputInventory(), this.level);
    }

    protected abstract OritechRecipeType getOwnRecipeType();

    public abstract InventorySlotAssignment getSlots();

    protected List<ItemStack> getInputView() {
        InventorySlotAssignment slots = this.getSlots();
        return this.inventory.items.subList(slots.inputStart(), slots.inputStart() + slots.inputCount());
    }

    protected List<ItemStack> getOutputView() {
        InventorySlotAssignment slots = this.getSlots();
        return this.inventory.items.subList(slots.outputStart(), slots.outputStart() + slots.outputCount());
    }

    protected RecipeInput getInputInventory() {
        return new SimpleCraftingInventory((ItemStack[])this.getInputView().toArray(ItemStack[]::new));
    }

    protected Container getOutputInventory() {
        return new SimpleContainer((ItemStack[])this.getOutputView().toArray(ItemStack[]::new));
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (boolean)false, (HolderLookup.Provider)registryLookup);
        nbt.putInt("oritech.machine_progress", this.progress);
        nbt.putLong("oritech.machine_energy", this.energyStorage.amount);
        nbt.putShort("oritech.machine_input_mode", (short)this.inventoryInputMode.ordinal());
        nbt.putBoolean("oritech.redstone", this.disabledViaRedstone);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (HolderLookup.Provider)registryLookup);
        this.progress = nbt.getInt("oritech.machine_progress");
        this.energyStorage.amount = nbt.getLong("oritech.machine_energy");
        this.inventoryInputMode = InventoryInputMode.values()[nbt.getShort("oritech.machine_input_mode")];
        this.disabledViaRedstone = nbt.getBoolean("oritech.redstone");
    }

    private int slotRecipeSearch(ItemStack stack, List<ItemStack> inv) {
        if (this.currentRecipe.getTime() != -1) {
            return this.findLowestMatchingSlot(stack, inv, false);
        }
        List availableRecipes = Objects.requireNonNull(this.level).getRecipeManager().getAllRecipesFor((RecipeType)this.getOwnRecipeType());
        HashSet<OritechRecipe> matchingStackRecipes = new HashSet<OritechRecipe>(availableRecipes.size() / 2);
        for (Object recipe : availableRecipes) {
            if (!this.recipeUsesStack(((OritechRecipe)recipe.value()).getInputs(), stack)) continue;
            matchingStackRecipes.add((OritechRecipe)recipe.value());
        }
        OritechRecipe result = null;
        for (OritechRecipe recipe : matchingStackRecipes) {
            if (!this.invCouldAllowRecipe(recipe, inv)) continue;
            result = recipe;
            break;
        }
        if (result == null) {
            return -1;
        }
        HashSet<Integer> searchTargets = new HashSet<Integer>();
        List<Ingredient> inputs = result.getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            Ingredient ingredient = inputs.get(i);
            if (!ingredient.test(stack)) continue;
            searchTargets.add(i);
        }
        int lowestCount = 64;
        int lowestIndex = -1;
        for (Integer slot : searchTargets) {
            ItemStack slotContent = inv.get(slot);
            if (slotContent.isEmpty()) {
                return slot;
            }
            if (slotContent.getCount() >= lowestCount) continue;
            lowestIndex = slot;
            lowestCount = slotContent.getCount();
        }
        return lowestIndex;
    }

    private boolean recipeUsesStack(List<Ingredient> inputs, ItemStack stack) {
        for (Ingredient ingredient : inputs) {
            if (!ingredient.test(stack)) continue;
            return true;
        }
        return false;
    }

    private boolean invCouldAllowRecipe(OritechRecipe recipe, List<ItemStack> inv) {
        List<Ingredient> inputs = recipe.getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            Ingredient ingredient = inputs.get(i);
            ItemStack slot = inv.get(i);
            if (slot.isEmpty() || ingredient.test(slot)) continue;
            return false;
        }
        return true;
    }

    private int findLowestMatchingSlot(ItemStack stack, List<ItemStack> inv, boolean allowEmpty) {
        int lowestMatchingIndex = -1;
        int lowestMatchingCount = 64;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack invSlot = inv.get(i);
            if (invSlot.isEmpty() && allowEmpty) {
                return i;
            }
            if (!invSlot.getItem().equals(stack.getItem()) || invSlot.getCount() >= lowestMatchingCount) continue;
            lowestMatchingIndex = i;
            lowestMatchingCount = invSlot.getCount();
        }
        return lowestMatchingIndex;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, this::onAnimationUpdate).triggerableAnim("setup", SETUP).setAnimationSpeedHandler(animatable -> this.getAnimationSpeed()).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler(this::getAnimationSpeed)));
    }

    public PlayState onAnimationUpdate(AnimationState<MachineBlockEntity> state) {
        if (state.getController().isPlayingTriggeredAnimation()) {
            return PlayState.CONTINUE;
        }
        if (this.isActive(this.getBlockState())) {
            if (this.isActivelyWorking()) {
                return state.setAndContinue(WORKING);
            }
            return state.setAndContinue(IDLE);
        }
        return state.setAndContinue(PACKAGED);
    }

    public boolean isActivelyWorking() {
        return this.level.getGameTime() - this.lastWorkedAt < 15L;
    }

    public void playSetupAnimation() {
        this.triggerAnim("base_controller", "setup");
    }

    protected float getAnimationSpeed() {
        if (this.getRecipeDuration() < 0) {
            return 1.0f;
        }
        float recipeTicks = (float)this.getRecipeDuration() * this.getSpeedMultiplier();
        return (float)this.getAnimationDuration() / recipeTicks * 0.99f;
    }

    public int getAnimationDuration() {
        return 60;
    }

    protected int getRecipeDuration() {
        return this.getCurrentRecipe().getTime();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    public Object getScreenOpeningData(ServerPlayer player) {
        this.sendNetworkEntry();
        return new ModScreens.BasicData(this.worldPosition);
    }

    protected Direction getFacing() {
        return (Direction)Objects.requireNonNull(this.level).getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
    }

    public Component getDisplayName() {
        return Component.literal((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new BasicMachineScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public EnergyApi.EnergyContainer getStorage(Direction direction) {
        return this.energyStorage;
    }

    @Override
    public abstract List<ScreenProvider.GuiSlot> getGuiSlots();

    @Override
    public float getProgress() {
        return (float)this.progress / ((float)this.currentRecipe.getTime() * this.getSpeedMultiplier());
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public DynamicEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public OritechRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void setCurrentRecipe(OritechRecipe currentRecipe) {
        this.currentRecipe = currentRecipe;
    }

    public float getSpeedMultiplier() {
        return 1.0f;
    }

    public float getEfficiencyMultiplier() {
        return 1.0f;
    }

    public void cycleInputMode() {
        switch (this.inventoryInputMode) {
            case FILL_LEFT_TO_RIGHT: {
                this.inventoryInputMode = InventoryInputMode.FILL_EVENLY;
                break;
            }
            case FILL_EVENLY: {
                this.inventoryInputMode = InventoryInputMode.FILL_MATCHING_RECIPE;
                break;
            }
            case FILL_MATCHING_RECIPE: {
                this.inventoryInputMode = InventoryInputMode.FILL_LEFT_TO_RIGHT;
            }
        }
        this.markNetDirty();
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return this.inventoryInputMode;
    }

    public void setInventoryInputMode(InventoryInputMode inventoryInputMode) {
        this.inventoryInputMode = inventoryInputMode;
    }

    public abstract int getInventorySize();

    @Override
    public Storage<ItemVariant> getInventory(Direction direction) {
        return InventoryStorage.of((Container)this.inventory, (Direction)direction);
    }

    public boolean isActive(BlockState state) {
        return true;
    }

    public void setEnergyStored(long amount) {
        this.energyStorage.amount = amount;
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return this.calculateEnergyUsage();
    }

    public long getDefaultCapacity() {
        return 5000L;
    }

    public long getDefaultInsertRate() {
        return 1024L;
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return this.energyStorage.maxInsert;
    }

    public long getDefaultExtractionRate() {
        return 0L;
    }

    public int getEnergyPerTick() {
        return this.energyPerTick;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    public void setChanged() {
        if (this.level != null) {
            this.level.blockEntityChanged(this.worldPosition);
        }
        this.markNetDirty();
    }

    @Override
    public int getComparatorEnergyAmount() {
        return (int)((float)this.energyStorage.amount / (float)this.energyStorage.capacity * 15.0f);
    }

    @Override
    public int getComparatorSlotAmount(int slot) {
        if (this.inventory.items.size() <= slot) {
            return 0;
        }
        ItemStack stack = this.inventory.getItem(slot);
        if (stack.isEmpty()) {
            return 0;
        }
        return (int)((float)stack.getCount() / (float)stack.getMaxStackSize() * 15.0f);
    }

    @Override
    public int getComparatorProgress() {
        if (this.currentRecipe.getTime() <= 0) {
            return 0;
        }
        return (int)((float)this.progress / (float)this.currentRecipe.getTime() * this.getSpeedMultiplier() * 15.0f);
    }

    @Override
    public int getComparatorActiveState() {
        return this.isActivelyWorking() ? 15 : 0;
    }

    @Override
    public void onRedstoneEvent(boolean isPowered) {
        this.disabledViaRedstone = isPowered;
    }

    private class SimpleMachineInventory
    extends SimpleSidedInventory {
        public SimpleMachineInventory(int size) {
            super(size, MachineBlockEntity.this.getSlots());
        }

        public void setChanged() {
            MachineBlockEntity.this.setChanged();
        }

        @Override
        public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction side) {
            if (!super.canPlaceItemThroughFace(slot, stack, side)) {
                return false;
            }
            InventoryInputMode mode = MachineBlockEntity.this.inventoryInputMode;
            InventorySlotAssignment config = MachineBlockEntity.this.getSlots();
            List<ItemStack> inv = MachineBlockEntity.this.getInputView();
            return switch (mode) {
                default -> throw new MatchException(null, null);
                case InventoryInputMode.FILL_EVENLY -> {
                    int target = MachineBlockEntity.this.findLowestMatchingSlot(stack, inv, true);
                    if (target >= 0 && config.inputToRealSlot(target) == slot) {
                        yield true;
                    }
                    yield false;
                }
                case InventoryInputMode.FILL_LEFT_TO_RIGHT -> true;
                case InventoryInputMode.FILL_MATCHING_RECIPE -> {
                    int recipeTargetSlot = MachineBlockEntity.this.slotRecipeSearch(stack, inv);
                    if (recipeTargetSlot >= 0 && config.inputToRealSlot(recipeTargetSlot) == slot) {
                        yield true;
                    }
                    yield false;
                }
            };
        }
    }
}

