/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.base.entity.FrameInteractionBlockEntity;
import rearth.oritech.block.entity.addons.RedstoneAddonBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventoryProvider;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.energy.EnergyApi;
import rearth.oritech.util.energy.containers.DynamicEnergyStorage;

public abstract class ItemEnergyFrameInteractionBlockEntity
extends FrameInteractionBlockEntity
implements InventoryProvider,
EnergyApi.BlockProvider,
ExtendedScreenHandlerFactory,
ScreenProvider,
MachineAddonController,
RedstoneAddonBlockEntity.RedstoneControllable {
    public final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(this.getDefaultCapacity(), this.getDefaultInsertRate(), 0L, this::setChanged);
    public final SimpleContainer inventory = new SimpleContainer(this.getInventorySize()){

        public void setChanged() {
            ItemEnergyFrameInteractionBlockEntity.this.setChanged();
        }
    };
    private final List<BlockPos> connectedAddons = new ArrayList<BlockPos>();
    private final List<BlockPos> openSlots = new ArrayList<BlockPos>();
    private MachineAddonController.BaseAddonData addonData = MachineAddonController.DEFAULT_ADDON_DATA;

    public ItemEnergyFrameInteractionBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public abstract int getMoveEnergyUsage();

    public abstract int getOperationEnergyUsage();

    @Override
    protected boolean canProgress() {
        return !this.disabledViaRedstone && (float)this.energyStorage.amount >= (float)this.getMoveEnergyUsage() * this.getBaseAddonData().efficiency() * (1.0f / this.getBaseAddonData().speed()) && (float)this.energyStorage.amount >= (float)this.getOperationEnergyUsage() * this.getBaseAddonData().efficiency() * (1.0f / this.getBaseAddonData().speed());
    }

    @Override
    protected void doProgress(boolean moving) {
        this.energyStorage.amount -= (long)((float)this.getMoveEnergyUsage() * this.getBaseAddonData().efficiency() * (1.0f / this.getBaseAddonData().speed()));
        this.setChanged();
    }

    @Override
    public void finishBlockWork(BlockPos processed) {
        this.energyStorage.amount -= (long)this.getOperationEnergyUsage();
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (HolderLookup.Provider)registryLookup);
        this.energyStorage.amount = nbt.getLong("energy_stored");
        this.disabledViaRedstone = nbt.getBoolean("oritech.redstone");
        this.loadAddonNbtData(nbt);
        this.updateEnergyContainer();
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (boolean)false, (HolderLookup.Provider)registryLookup);
        nbt.putLong("energy_stored", this.energyStorage.amount);
        nbt.putBoolean("oritech.redstone", this.disabledViaRedstone);
        this.writeAddonToNbt(nbt);
    }

    @Override
    public Storage<ItemVariant> getInventory(Direction direction) {
        return InventoryStorage.of((Container)this.inventory, (Direction)direction);
    }

    @Override
    public EnergyApi.EnergyContainer getStorage(Direction direction) {
        return this.energyStorage;
    }

    @Override
    public BlockPos getMachinePos() {
        return this.getBlockPos();
    }

    @Override
    public Level getMachineWorld() {
        return this.getLevel();
    }

    public Object getScreenOpeningData(ServerPlayer player) {
        this.updateNetwork();
        return new ModScreens.UpgradableData(this.worldPosition, this.getUiData(), this.getCoreQuality());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.FullEnergySyncPacket(this.worldPosition, this.energyStorage.amount, this.energyStorage.capacity, this.energyStorage.maxInsert, this.energyStorage.maxExtract));
        return new UpgradableMachineScreenHandler(syncId, playerInventory, this, this.getUiData(), this.getCoreQuality());
    }

    public Component getDisplayName() {
        return Component.nullToEmpty((String)"");
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 50, 11));
    }

    public int getInventorySize() {
        return 1;
    }

    @Override
    public float getProgress() {
        long time;
        if (this.level.isClientSide && (time = this.level.getGameTime()) < this.getMoveStartedAt() + (long)this.getMoveTime() && this.getMoveStartedAt() > 1L) {
            return 0.0f;
        }
        return (float)this.getCurrentProgress() / (float)this.getWorkTime();
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return (float)this.getOperationEnergyUsage() * this.getBaseAddonData().efficiency() * (1.0f / this.getBaseAddonData().speed());
    }

    @Override
    public long getDefaultCapacity() {
        return 10000L;
    }

    @Override
    public long getDefaultInsertRate() {
        return 512L;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return this.energyStorage.maxInsert;
    }

    @Override
    public void tick(Level world, BlockPos pos, BlockState state, FrameInteractionBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (!world.isClientSide && this.isActivelyViewed()) {
            NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.MachineFrameGuiPacket(pos, this.energyStorage.amount, this.energyStorage.capacity, this.getCurrentProgress()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isActivelyViewed() {
        Player closestPlayer = Objects.requireNonNull(this.level).getNearestPlayer((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), 5.0, false);
        if (closestPlayer == null) return false;
        AbstractContainerMenu abstractContainerMenu = closestPlayer.containerMenu;
        if (!(abstractContainerMenu instanceof BasicMachineScreenHandler)) return false;
        BasicMachineScreenHandler handler = (BasicMachineScreenHandler)abstractContainerMenu;
        if (!this.getBlockPos().equals((Object)handler.getBlockPos())) return false;
        return true;
    }

    @Override
    public SimpleContainer getInventoryForAddon() {
        return this.inventory;
    }

    @Override
    public ScreenProvider getScreenProvider() {
        return this;
    }

    @Override
    public float getSpeedMultiplier() {
        return this.addonData.speed();
    }

    public DynamicEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public List<BlockPos> getConnectedAddons() {
        return this.connectedAddons;
    }

    @Override
    public List<BlockPos> getOpenSlots() {
        return this.openSlots;
    }

    @Override
    public Direction getFacingForAddon() {
        return super.getFacing();
    }

    @Override
    public DynamicEnergyStorage getStorageForAddon() {
        return this.getEnergyStorage();
    }

    @Override
    public MachineAddonController.BaseAddonData getBaseAddonData() {
        return this.addonData;
    }

    @Override
    public void setBaseAddonData(MachineAddonController.BaseAddonData data) {
        this.addonData = data;
        this.setChanged();
    }

    public boolean isActivelyWorking() {
        return this.level.getGameTime() - this.lastWorkedAt < 5L;
    }

    @Override
    public int getComparatorEnergyAmount() {
        return (int)((float)this.energyStorage.amount / (float)this.energyStorage.capacity * 15.0f);
    }

    @Override
    public int getComparatorSlotAmount(int slot) {
        if (this.inventory.items.size() <= slot) {
            return 0;
        }
        ItemStack stack = this.inventory.getItem(slot);
        if (stack.isEmpty()) {
            return 0;
        }
        return (int)((float)stack.getCount() / (float)stack.getMaxStackSize() * 15.0f);
    }

    @Override
    public int getComparatorProgress() {
        return 0;
    }

    @Override
    public int getComparatorActiveState() {
        return this.isActivelyWorking() ? 15 : 0;
    }

    @Override
    public void onRedstoneEvent(boolean isPowered) {
        this.disabledViaRedstone = isPowered;
    }

    @Override
    public int receivedRedstoneSignal() {
        if (this.disabledViaRedstone) {
            return 15;
        }
        return 0;
    }

    @Override
    public String currentRedstoneEffect() {
        if (this.disabledViaRedstone) {
            return "tooltip.oritech.redstone_disabled";
        }
        return "tooltip.oritech.redstone_enabled";
    }
}

