/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.entity;

import com.mojang.serialization.Codec;
import dev.architectury.fluid.FluidStack;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.base.entity.MultiblockGeneratorBlockEntity;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.FluidProvider;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;

public abstract class FluidMultiblockGeneratorBlockEntity
extends MultiblockGeneratorBlockEntity
implements FluidProvider {
    public final SingleVariantStorage<FluidVariant> inputTank = new SingleVariantStorage<FluidVariant>(){

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected long getCapacity(FluidVariant variant) {
            return 324000L;
        }

        public boolean supportsExtraction() {
            return false;
        }

        protected void onFinalCommit() {
            super.onFinalCommit();
            FluidMultiblockGeneratorBlockEntity.this.setChanged();
        }
    };

    public FluidMultiblockGeneratorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int energyPerTick) {
        super(type, pos, state, energyPerTick);
    }

    @Override
    public void tick(Level world, BlockPos pos, BlockState state, MachineBlockEntity blockEntity) {
        if (this.bucketInputAllowed() && !world.isClientSide && this.isActive(state) && !this.inventory.getItem(0).isEmpty()) {
            this.processBuckets();
        }
        FluidMultiblockGeneratorBlockEntity.resetEmptyFluidTank(this.inputTank);
        super.tick(world, pos, state, blockEntity);
    }

    public static void resetEmptyFluidTank(SingleVariantStorage<FluidVariant> tank) {
        if (!tank.isResourceBlank() && tank.amount <= 0L) {
            tank.variant = FluidVariant.blank();
        }
    }

    private void processBuckets() {
        ItemStack inStack = this.inventory.getItem(0);
        ItemStack emptyBucket = ItemVariant.of((ItemLike)Items.BUCKET, (DataComponentPatch)inStack.getComponentsPatch()).toStack();
        Item item = inStack.getItem();
        if (item instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)item;
            if (this.outputCanAcceptBucket(emptyBucket)) {
                Fluid bucketFluid = bucketItem.arch$getFluid();
                if (bucketFluid == Fluids.EMPTY) {
                    return;
                }
                try (Transaction tx = Transaction.openOuter();){
                    long inserted = this.inputTank.insert((TransferVariant)FluidVariant.of((Fluid)bucketFluid), 81000L, (TransactionContext)tx);
                    if (inserted != 81000L) {
                        return;
                    }
                    inStack.shrink(1);
                    if (this.inventory.getItem(1).isEmpty()) {
                        this.inventory.items.set(1, (Object)emptyBucket);
                    } else {
                        this.inventory.getItem(1).grow(1);
                    }
                    this.inventory.items.set(0, (Object)inStack);
                    tx.commit();
                }
            }
        }
    }

    private boolean outputCanAcceptBucket(ItemStack bucket) {
        ItemStack slot = this.inventory.getItem(1);
        return slot.isEmpty() || slot.isStackable() && ItemStack.isSameItemSameComponents((ItemStack)slot, (ItemStack)bucket) && slot.getCount() < slot.getMaxStackSize();
    }

    @Override
    protected void tryConsumeInput() {
        if (this.isProducingSteam && (this.waterStorage.amount == 0L || this.steamStorage.amount == this.steamStorage.getCapacity())) {
            return;
        }
        Optional<RecipeHolder<OritechRecipe>> recipeCandidate = this.getRecipe();
        if (recipeCandidate.isEmpty()) {
            this.currentRecipe = OritechRecipe.DUMMY;
        }
        if (recipeCandidate.isPresent()) {
            OritechRecipe activeRecipe;
            this.currentRecipe = activeRecipe = (OritechRecipe)recipeCandidate.get().value();
            this.consumeFluidRecipeInput(activeRecipe);
        }
    }

    protected void consumeFluidRecipeInput(OritechRecipe activeRecipe) {
        int recipeTime;
        this.progress = recipeTime = (int)((float)this.currentRecipe.getTime() * this.getSpeedMultiplier() * (1.0f / this.getEfficiencyMultiplier()));
        this.setCurrentMaxBurnTime(recipeTime);
        FluidStack fluidStack = activeRecipe.getFluidInput();
        this.inputTank.amount -= fluidStack.getAmount();
        this.markNetDirty();
        this.setChanged();
    }

    @Override
    protected Optional<RecipeHolder<OritechRecipe>> getRecipe() {
        return this.getRecipe(this.inputTank);
    }

    protected Optional<RecipeHolder<OritechRecipe>> getRecipe(SingleVariantStorage<FluidVariant> checkedTank) {
        if (checkedTank.isResourceBlank() || checkedTank.amount <= 0L) {
            return Optional.empty();
        }
        List availableRecipes = this.level.getRecipeManager().getAllRecipesFor((RecipeType)this.getOwnRecipeType());
        for (RecipeHolder recipeEntry : availableRecipes) {
            OritechRecipe recipe = (OritechRecipe)recipeEntry.value();
            FluidStack recipeFluid = recipe.getFluidInput();
            if (!recipeFluid.getFluid().equals(((FluidVariant)checkedTank.variant).getFluid()) || checkedTank.amount < recipeFluid.getAmount()) continue;
            return Optional.of(recipeEntry);
        }
        return Optional.empty();
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        SingleVariantStorage.writeNbt(this.inputTank, (Codec)FluidVariant.CODEC, (CompoundTag)nbt, (HolderLookup.Provider)registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (boolean)false, (HolderLookup.Provider)registryLookup);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        SingleVariantStorage.readNbt(this.inputTank, (Codec)FluidVariant.CODEC, FluidVariant::blank, (CompoundTag)nbt, (HolderLookup.Provider)registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (HolderLookup.Provider)registryLookup);
    }

    @Override
    protected void sendNetworkEntry() {
        super.sendNetworkEntry();
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.SingleVariantFluidSyncPacket(this.worldPosition, BuiltInRegistries.FLUID.getKey((Object)((FluidVariant)this.inputTank.variant).getFluid()).toString(), this.inputTank.amount));
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 55, 35), new ScreenProvider.GuiSlot(1, 112, 35, true));
    }

    @Override
    public InventorySlotAssignment getSlots() {
        return new InventorySlotAssignment(0, 1, 1, 1);
    }

    public boolean bucketInputAllowed() {
        return true;
    }

    @Override
    public int getInventorySize() {
        return 2;
    }

    @Override
    public Storage<FluidVariant> getFluidStorage(Direction direction) {
        return this.inputTank;
    }

    @Override
    @Nullable
    public SingleVariantStorage<FluidVariant> getForDirectFluidAccess() {
        return this.inputTank;
    }
}

