/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.blocks.storage.SmallStorageBlock;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.init.ItemContent;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventoryProvider;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.energy.EnergyApi;
import rearth.oritech.util.energy.containers.DelegatingEnergyStorage;
import rearth.oritech.util.energy.containers.DynamicEnergyStorage;

public abstract class ExpandableEnergyStorageBlockEntity
extends BlockEntity
implements EnergyApi.BlockProvider,
InventoryProvider,
MachineAddonController,
ScreenProvider,
ExtendedScreenHandlerFactory,
BlockEntityTicker<ExpandableEnergyStorageBlockEntity> {
    private final List<BlockPos> connectedAddons = new ArrayList<BlockPos>();
    private final List<BlockPos> openSlots = new ArrayList<BlockPos>();
    private MachineAddonController.BaseAddonData addonData = MachineAddonController.DEFAULT_ADDON_DATA;
    private boolean networkDirty = false;
    private boolean redstonePowered;
    public final SimpleContainer inventory = new SimpleContainer(1){

        public void setChanged() {
            ExpandableEnergyStorageBlockEntity.this.setChanged();
        }
    };
    protected final InventoryStorage inventoryStorage = InventoryStorage.of((Container)this.inventory, null);
    protected final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(this.getDefaultCapacity(), this.getDefaultInsertRate(), this.getDefaultExtractionRate(), this::setChanged);
    private final EnergyApi.EnergyContainer outputStorage = new DelegatingEnergyStorage(this, this.energyStorage, null){

        @Override
        public boolean supportsInsertion() {
            return false;
        }
    };
    private final EnergyApi.EnergyContainer inputStorage = new DelegatingEnergyStorage(this, this.energyStorage, null){

        @Override
        public boolean supportsExtraction() {
            return false;
        }
    };

    public ExpandableEnergyStorageBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick(Level world, BlockPos pos, BlockState state, ExpandableEnergyStorageBlockEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        if (!this.redstonePowered) {
            this.outputEnergy();
        }
        this.inputFromCrystal();
        if (this.networkDirty) {
            this.sendNetworkEntry();
        }
    }

    private void inputFromCrystal() {
        if (this.energyStorage.amount >= this.energyStorage.capacity || this.inventory.isEmpty()) {
            return;
        }
        if (!this.inventory.getItem(0).getItem().equals(ItemContent.OVERCHARGED_CRYSTAL)) {
            return;
        }
        this.energyStorage.amount = Math.min(this.energyStorage.capacity, this.energyStorage.amount + (long)Oritech.CONFIG.overchargedCrystalChargeRate());
    }

    private void outputEnergy() {
        if (this.energyStorage.amount <= 0L) {
            return;
        }
        this.chargeItems();
        Tuple<Direction, BlockPos> target = ExpandableEnergyStorageBlockEntity.getOutputPosition(this.worldPosition, this.getFacing());
        EnergyApi.EnergyContainer candidate = EnergyApi.BLOCK.find(this.level, (BlockPos)target.getB(), (Direction)target.getA());
        if (candidate != null) {
            EnergyApi.transfer(this.energyStorage, candidate, Long.MAX_VALUE, false);
        }
    }

    private void chargeItems() {
        ItemStack heldStack = (ItemStack)this.inventory.items.get(0);
        if (heldStack.isEmpty()) {
            return;
        }
        ContainerItemContext slot = ContainerItemContext.ofSingleSlot((SingleSlotStorage)this.inventoryStorage.getSlot(0));
        EnergyApi.EnergyContainer slotEnergyContainer = EnergyApi.ITEM.find(heldStack, slot);
        if (slotEnergyContainer != null) {
            EnergyApi.transfer(this.energyStorage, slotEnergyContainer, Long.MAX_VALUE, false);
        }
    }

    public static Tuple<Direction, BlockPos> getOutputPosition(BlockPos pos, Direction facing) {
        BlockPos blockInFront = (BlockPos)Geometry.offsetToWorldPosition(facing, new Vec3i(-1, 0, 0), (Vec3i)pos);
        BlockPos worldOffset = blockInFront.subtract((Vec3i)pos);
        Direction direction = Direction.fromDelta((int)worldOffset.getX(), (int)worldOffset.getY(), (int)worldOffset.getZ());
        return new Tuple((Object)direction, (Object)blockInFront);
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        this.writeAddonToNbt(nbt);
        nbt.putLong("energy_stored", this.energyStorage.amount);
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (boolean)false, (HolderLookup.Provider)registryLookup);
        nbt.putBoolean("redstone", this.redstonePowered);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.loadAddonNbtData(nbt);
        this.updateEnergyContainer();
        this.energyStorage.amount = nbt.getLong("energy_stored");
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (HolderLookup.Provider)registryLookup);
        this.redstonePowered = nbt.getBoolean("redstone");
    }

    @Override
    public Storage<ItemVariant> getInventory(Direction direction) {
        return this.inventoryStorage;
    }

    public Direction getFacing() {
        return (Direction)this.getBlockState().getValue((Property)SmallStorageBlock.TARGET_DIR);
    }

    @Override
    public EnergyApi.EnergyContainer getStorage(Direction direction) {
        if (direction == null) {
            return this.energyStorage;
        }
        if (direction.equals((Object)this.getFacing())) {
            return this.outputStorage;
        }
        return this.inputStorage;
    }

    @Override
    public List<BlockPos> getConnectedAddons() {
        return this.connectedAddons;
    }

    @Override
    public List<BlockPos> getOpenSlots() {
        return this.openSlots;
    }

    @Override
    public Direction getFacingForAddon() {
        Direction facing = (Direction)Objects.requireNonNull(this.level).getBlockState(this.getBlockPos()).getValue((Property)SmallStorageBlock.TARGET_DIR);
        if (facing.equals((Object)Direction.UP) || facing.equals((Object)Direction.DOWN)) {
            return Direction.NORTH;
        }
        return facing;
    }

    @Override
    public DynamicEnergyStorage getStorageForAddon() {
        return this.energyStorage;
    }

    @Override
    public SimpleContainer getInventoryForAddon() {
        return this.inventory;
    }

    @Override
    public ScreenProvider getScreenProvider() {
        return this;
    }

    @Override
    public MachineAddonController.BaseAddonData getBaseAddonData() {
        return this.addonData;
    }

    @Override
    public void setBaseAddonData(MachineAddonController.BaseAddonData data) {
        this.addonData = data;
    }

    @Override
    public void updateEnergyContainer() {
        MachineAddonController.super.updateEnergyContainer();
        this.energyStorage.maxExtract = this.getDefaultExtractionRate() + this.addonData.energyBonusTransfer();
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return this.energyStorage.maxInsert;
    }

    public abstract long getDefaultExtractionRate();

    public Object getScreenOpeningData(ServerPlayer player) {
        this.sendNetworkEntry();
        return new ModScreens.UpgradableData(this.worldPosition, this.getUiData(), this.getCoreQuality());
    }

    public void setChanged() {
        super.setChanged();
        this.networkDirty = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isActivelyViewed() {
        Player closestPlayer = Objects.requireNonNull(this.level).getNearestPlayer((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), 5.0, false);
        if (closestPlayer == null) return false;
        AbstractContainerMenu abstractContainerMenu = closestPlayer.containerMenu;
        if (!(abstractContainerMenu instanceof BasicMachineScreenHandler)) return false;
        BasicMachineScreenHandler handler = (BasicMachineScreenHandler)abstractContainerMenu;
        if (!this.getBlockPos().equals((Object)handler.getBlockPos())) return false;
        return true;
    }

    protected void sendNetworkEntry() {
        if (this.level.getGameTime() % 15L != 0L && !this.isActivelyViewed()) {
            return;
        }
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.GenericEnergySyncPacket(this.worldPosition, this.energyStorage.amount, this.energyStorage.capacity));
        this.networkDirty = false;
    }

    public Component getDisplayName() {
        return Component.literal((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.FullEnergySyncPacket(this.worldPosition, this.energyStorage.amount, this.energyStorage.capacity, this.energyStorage.maxInsert, this.energyStorage.maxExtract));
        return new UpgradableMachineScreenHandler(syncId, playerInventory, this, this.getUiData(), this.getCoreQuality());
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 80, 35));
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 0.0f;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public BlockPos getMachinePos() {
        return this.getBlockPos();
    }

    @Override
    public Level getMachineWorld() {
        return this.getLevel();
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.STORAGE_SCREEN;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public Property<Direction> getBlockFacingProperty() {
        return SmallStorageBlock.TARGET_DIR;
    }

    public void setRedstonePowered(boolean isPowered) {
        this.redstonePowered = isPowered;
    }

    @Override
    public boolean hasRedstoneControlAvailable() {
        return true;
    }

    @Override
    public int receivedRedstoneSignal() {
        if (this.redstonePowered) {
            return 15;
        }
        return this.level.getBestNeighborSignal(this.worldPosition);
    }

    @Override
    public String currentRedstoneEffect() {
        if (this.receivedRedstoneSignal() > 0) {
            return "tooltip.oritech.redstone_disabled_storage";
        }
        return "tooltip.oritech.redstone_enabled_direct";
    }
}

