/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import rearth.oritech.block.base.block.MachineBlock;
import rearth.oritech.util.MachineAddonController;

public abstract class UpgradableMachineBlock
extends MachineBlock {
    public UpgradableMachineBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide) {
            BlockEntity entity = world.getBlockEntity(pos);
            if (!(entity instanceof MachineAddonController)) {
                return InteractionResult.SUCCESS;
            }
            MachineAddonController machineEntity = (MachineAddonController)entity;
            machineEntity.initAddons();
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    @Override
    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity entity;
        if (!world.isClientSide() && (entity = world.getBlockEntity(pos)) instanceof MachineAddonController) {
            MachineAddonController machineEntity = (MachineAddonController)entity;
            machineEntity.resetAddons();
        }
        return super.playerWillDestroy(world, pos, state, player);
    }
}

