/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech;

import com.mojang.blaze3d.platform.InputConstants;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRenderEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.augmenter.PlayerAugments;
import rearth.oritech.client.init.ModRenderers;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.other.OreFinderRenderer;
import rearth.oritech.client.renderers.BlockOutlineRenderer;
import rearth.oritech.client.ui.AugmentSelectionScreen;
import rearth.oritech.item.tools.armor.BaseJetpackItem;
import rearth.oritech.item.tools.util.Helpers;

public final class OritechClient {
    public static final KeyMapping AUGMENT_SELECTOR = new KeyMapping("key.oritech.augment_screen", 71, "key.categories.misc");
    public static AugmentSelectionScreen activeScreen = null;

    public static void initialize() {
        Oritech.LOGGER.info("Oritech client initialization");
        ModScreens.assignScreens();
        KeyBindingHelper.registerKeyBinding((KeyMapping)AUGMENT_SELECTOR);
        ClientTickEvents.START_CLIENT_TICK.register(Helpers::onClientTickEvent);
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            if (AUGMENT_SELECTOR.consumeClick() && activeScreen == null) {
                activeScreen = new AugmentSelectionScreen();
                client.setScreen((Screen)activeScreen);
            } else if (activeScreen != null && !InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)OritechClient.AUGMENT_SELECTOR.key.getValue())) {
                activeScreen.onClose();
            }
        });
        LivingEntityFeatureRenderEvents.ALLOW_CAPE_RENDER.register(player -> !(player.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof BaseJetpackItem));
        WorldRenderEvents.BLOCK_OUTLINE.register(OritechClient::renderBlockOutline);
        WorldRenderEvents.AFTER_ENTITIES.register(OreFinderRenderer::doRender);
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            if (client.player != null) {
                PlayerAugments.clientTickAugments((Player)client.player);
            }
        });
        Oritech.LOGGER.info("Oritech client initialization done");
    }

    public static boolean renderBlockOutline(WorldRenderContext worldRenderContext, WorldRenderContext.BlockOutlineContext blockOutlineContext) {
        BlockOutlineRenderer.render(worldRenderContext.world(), worldRenderContext.camera(), worldRenderContext.tickCounter(), worldRenderContext.matrixStack(), worldRenderContext.consumers(), worldRenderContext.gameRenderer(), worldRenderContext.projectionMatrix(), worldRenderContext.lightmapTextureManager(), worldRenderContext.worldRenderer());
        return true;
    }

    public static void registerRenderers() {
        Oritech.LOGGER.info("Registering oritech renderers");
        ModRenderers.registerRenderers();
    }
}

