/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.trophy;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.trophy.Trophy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.conditions.WithConditions;
import org.apache.logging.log4j.Logger;

public class TrophyReloadListener
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final TreeMap<ResourceLocation, Trophy> validTrophies = new TreeMap();

    public TrophyReloadListener() {
        super(GSON, "trophies");
    }

    public static TreeMap<ResourceLocation, Trophy> getValidTrophies() {
        return validTrophies;
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profiler) {
        validTrophies.clear();
        HashMap replacementMap = new HashMap();
        map.forEach((resourceLocation, jsonElement) -> {
            if (ModList.get().isLoaded(resourceLocation.getNamespace())) {
                try {
                    Optional conditionedTrophy = (Optional)Trophy.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement).resultOrPartial(arg_0 -> ((Logger)OpenBlocksTrophies.LOGGER).error(arg_0)).orElseThrow();
                    if (conditionedTrophy.isPresent()) {
                        Trophy trophy = (Trophy)((WithConditions)conditionedTrophy.get()).carrier();
                        ResourceLocation mob = BuiltInRegistries.ENTITY_TYPE.getKey(trophy.type());
                        if (trophy.replace()) {
                            replacementMap.put(mob, trophy);
                        } else if (validTrophies.containsKey(mob)) {
                            Trophy existing = validTrophies.get(mob);
                            Trophy combinedTrophy = new Trophy.Builder(existing.type()).copyFrom(existing).addVariants(trophy.variants().right().orElse(new ArrayList())).build();
                            validTrophies.put(BuiltInRegistries.ENTITY_TYPE.getKey(combinedTrophy.type()), combinedTrophy);
                        } else if (BuiltInRegistries.ENTITY_TYPE.containsValue(trophy.type())) {
                            validTrophies.put(mob, trophy);
                        }
                    } else {
                        OpenBlocksTrophies.LOGGER.debug("Skipped loading trophy {} as its conditions were not met", resourceLocation);
                    }
                }
                catch (Exception exception) {
                    OpenBlocksTrophies.LOGGER.error("Caught an error loading trophy config for {}!", resourceLocation, (Object)exception);
                }
            }
        });
        validTrophies.putAll(replacementMap);
        OpenBlocksTrophies.LOGGER.info("Loaded {} Trophy configs.", (Object)validTrophies.size());
    }
}

