/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.trophy;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.behavior.CustomBehavior;
import com.gizmo.trophies.behavior.CustomBehaviorType;
import com.gizmo.trophies.trophy.TrophyReloadListener;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;
import org.jetbrains.annotations.Nullable;

public record Trophy(boolean replace, EntityType<?> type, double dropChance, Vec3 offset, Vec3 rotation, float scale, Optional<CustomBehavior> clickBehavior, Either<Pair<String, ResourceLocation>, List<CompoundTag>> variants, Optional<CompoundTag> defaultData, Optional<SoundEvent> clickSoundOverride) {
    public static final double DEFAULT_DROP_CHANCE = 0.001;
    public static final double BOSS_DROP_CHANCE = 0.0075;
    public static final Codec<Trophy> BASE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(Trophy::replace), (App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entity").forGetter(Trophy::type), (App)Codec.DOUBLE.optionalFieldOf("drop_chance", (Object)0.001).forGetter(Trophy::dropChance), (App)Vec3.CODEC.optionalFieldOf("offset", (Object)Vec3.ZERO).forGetter(Trophy::offset), (App)Vec3.CODEC.optionalFieldOf("rotation", (Object)Vec3.ZERO).forGetter(Trophy::rotation), (App)Codec.FLOAT.optionalFieldOf("scale", (Object)Float.valueOf(1.0f)).forGetter(Trophy::scale), (App)CustomBehaviorType.DISPATCH_CODEC.optionalFieldOf("behavior").forGetter(Trophy::clickBehavior), (App)Codec.either((Codec)Codec.pair((Codec)Codec.STRING.fieldOf("key").codec(), (Codec)ResourceLocation.CODEC.fieldOf("registry").codec()), (Codec)CompoundTag.CODEC.listOf()).optionalFieldOf("variants", (Object)Either.right(new ArrayList())).forGetter(Trophy::variants), (App)CompoundTag.CODEC.optionalFieldOf("default_variant").forGetter(Trophy::defaultData), (App)SoundEvent.DIRECT_CODEC.optionalFieldOf("click_sound_override").forGetter(Trophy::clickSoundOverride)).apply((Applicative)instance, Trophy::new));
    public static final Codec<Optional<WithConditions<Trophy>>> CODEC = ConditionalOps.createConditionalCodecWithConditions(BASE_CODEC);

    public List<CompoundTag> getVariants(@Nullable HolderLookup.Provider access) {
        if (this.variants.left().isPresent() && access != null) {
            ArrayList<CompoundTag> entries = new ArrayList<CompoundTag>();
            Pair registryVariant = (Pair)this.variants.left().get();
            HolderLookup.RegistryLookup registry = access.lookupOrThrow(ResourceKey.createRegistryKey((ResourceLocation)((ResourceLocation)registryVariant.getSecond())));
            for (ResourceKey entry : registry.listElementIds().toList()) {
                try {
                    CompoundTag formattedTag = (CompoundTag)Util.make((Object)new CompoundTag(), tag -> tag.putString((String)registryVariant.getFirst(), entry.location().toString()));
                    if (entries.contains(formattedTag)) continue;
                    entries.add(formattedTag);
                }
                catch (Exception e) {
                    OpenBlocksTrophies.LOGGER.error("Something went wrong when trying to fetch variants from a registry!", (Throwable)e);
                }
            }
            return entries;
        }
        return this.variants.right().orElse(new ArrayList());
    }

    public static TreeMap<ResourceLocation, Trophy> getTrophies() {
        return TrophyReloadListener.getValidTrophies();
    }

    public static class Builder {
        private boolean replace;
        private final EntityType<?> type;
        private double dropChance = 0.001;
        private Vec3 offset = Vec3.ZERO;
        private Vec3 rotation = Vec3.ZERO;
        private float scale = 1.0f;
        @Nullable
        private CustomBehavior clickBehavior = null;
        @Nullable
        private Pair<String, ResourceLocation> registryVariant;
        private List<CompoundTag> variants = new ArrayList<CompoundTag>();
        @Nullable
        private CompoundTag defaultVariant = null;
        @Nullable
        private SoundEvent soundOverride = null;
        public List<ICondition> conditions = new ArrayList<ICondition>();

        public Builder(EntityType<?> type) {
            this.type = type;
        }

        public Builder copyFrom(Trophy trophy) {
            this.dropChance = trophy.dropChance();
            this.offset = trophy.offset();
            this.rotation = trophy.rotation();
            this.scale = trophy.scale();
            this.clickBehavior = trophy.clickBehavior().orElse(null);
            this.registryVariant = trophy.variants().left().orElse(null);
            this.variants = new ArrayList<CompoundTag>(trophy.variants().right().orElse(new ArrayList()));
            this.defaultVariant = trophy.defaultData().orElse(null);
            this.soundOverride = trophy.clickSoundOverride().orElse(null);
            return this;
        }

        public Builder replace() {
            this.replace = true;
            return this;
        }

        public Builder setDropChance(double chance) {
            this.dropChance = chance;
            return this;
        }

        public Builder setOffset(double xOffset, double yOffset, double zOffset) {
            this.offset = new Vec3(xOffset, yOffset, zOffset);
            return this;
        }

        public Builder setRotation(double xOffset, double yOffset, double zOffset) {
            this.rotation = new Vec3(xOffset, yOffset, zOffset);
            return this;
        }

        public Builder setScale(float scale) {
            this.scale = scale;
            return this;
        }

        public Builder setRightClickBehavior(CustomBehavior behavior) {
            this.clickBehavior = behavior;
            return this;
        }

        public Builder addVariant(String variantId, String value) {
            CompoundTag tag = new CompoundTag();
            tag.putString(variantId, value);
            this.variants.add(tag);
            return this;
        }

        public Builder addVariant(String variantId, int value) {
            CompoundTag tag = new CompoundTag();
            tag.putInt(variantId, value);
            this.variants.add(tag);
            return this;
        }

        public Builder addVariant(String variantId, float value) {
            CompoundTag tag = new CompoundTag();
            tag.putFloat(variantId, value);
            this.variants.add(tag);
            return this;
        }

        public Builder addVariant(String variantId, double value) {
            CompoundTag tag = new CompoundTag();
            tag.putDouble(variantId, value);
            this.variants.add(tag);
            return this;
        }

        public Builder addVariant(String variantId, boolean value) {
            CompoundTag tag = new CompoundTag();
            tag.putBoolean(variantId, value);
            this.variants.add(tag);
            return this;
        }

        public Builder addVariant(CompoundTag variant) {
            this.variants.add(variant);
            return this;
        }

        public Builder addVariants(List<CompoundTag> variant) {
            this.variants.addAll(variant);
            return this;
        }

        public Builder addRegistryVariant(String key, ResourceLocation registryName) {
            this.registryVariant = Pair.of((Object)key, (Object)registryName);
            return this;
        }

        public Builder addDefaultVariant(CompoundTag variant) {
            this.defaultVariant = variant;
            return this;
        }

        public Builder addCondition(ICondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public Builder addSoundOverride(SoundEvent sound) {
            this.soundOverride = sound;
            return this;
        }

        public Trophy build() {
            return new Trophy(this.replace, this.type, this.dropChance, this.offset, this.rotation, this.scale, Optional.ofNullable(this.clickBehavior), (Either<Pair<String, ResourceLocation>, List<CompoundTag>>)(this.registryVariant != null ? Either.left(this.registryVariant) : Either.right(this.variants)), Optional.ofNullable(this.defaultVariant), Optional.ofNullable(this.soundOverride));
        }
    }
}

