/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.network;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.trophy.Trophy;
import com.gizmo.trophies.trophy.TrophyReloadListener;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncTrophyConfigsPacket(Map<ResourceLocation, Trophy> trophies) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncTrophyConfigsPacket> TYPE = new CustomPacketPayload.Type(OpenBlocksTrophies.prefix("sync_trophy_configs"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncTrophyConfigsPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(Maps::newHashMapWithExpectedSize, (StreamCodec)ResourceLocation.STREAM_CODEC, (StreamCodec)ByteBufCodecs.fromCodecTrusted(Trophy.BASE_CODEC)), SyncTrophyConfigsPacket::trophies, SyncTrophyConfigsPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SyncTrophyConfigsPacket message, IPayloadContext context) {
        context.enqueueWork(() -> {
            TrophyReloadListener.getValidTrophies().putAll(message.trophies());
            OpenBlocksTrophies.LOGGER.debug("Received {} trophy configs from server.", (Object)message.trophies().size());
        });
    }
}

