/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.misc;

import com.gizmo.trophies.client.CreativeModeVariantToggle;
import com.gizmo.trophies.item.TrophyItem;
import com.gizmo.trophies.trophy.Trophy;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.loading.FMLLoader;

public class TrophyTabHelper {
    public static ItemStack makeIcon() {
        return TrophyItem.createCyclingTrophy(EntityType.CHICKEN);
    }

    public static void getAllTrophies(CreativeModeTab.Output output, HolderLookup.Provider provider, FeatureFlagSet flags, boolean showVariants) {
        if (!Trophy.getTrophies().isEmpty()) {
            TreeMap sortedTrophies = new TreeMap(Comparator.naturalOrder());
            sortedTrophies.putAll(Trophy.getTrophies());
            for (Map.Entry trophyEntry : sortedTrophies.entrySet()) {
                if (!((Trophy)trophyEntry.getValue()).type().isEnabled(flags)) continue;
                if (!((Trophy)trophyEntry.getValue()).getVariants(provider).isEmpty() && showVariants) {
                    ((Trophy)trophyEntry.getValue()).getVariants(provider).forEach(tag -> output.accept(TrophyItem.loadVariantToTrophy(((Trophy)trophyEntry.getValue()).type(), tag)));
                    continue;
                }
                output.accept(TrophyItem.loadEntityToTrophy(((Trophy)trophyEntry.getValue()).type()));
            }
        }
    }

    public static boolean shouldShowVariants() {
        if (FMLLoader.getDist().isClient()) {
            return CreativeModeVariantToggle.showVariants == null || CreativeModeVariantToggle.showVariants.isSelected();
        }
        return true;
    }
}

