/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.misc;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.config.TrophyConfig;
import com.gizmo.trophies.item.TrophyItem;
import com.gizmo.trophies.network.SyncTrophyConfigsPacket;
import com.gizmo.trophies.trophy.Trophy;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.loot.LootContext;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.AdvancementEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class TrophyEvents {
    public static final RandomSource TROPHY_RANDOM = RandomSource.create();

    public static void syncTrophiesToClient(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)event.getPlayer(), (CustomPacketPayload)new SyncTrophyConfigsPacket(Trophy.getTrophies()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            OpenBlocksTrophies.LOGGER.debug("Sent {} trophy configs to {} from server.", (Object)Trophy.getTrophies().size(), (Object)event.getPlayer().getDisplayName().getString());
        } else {
            event.getPlayerList().getPlayers().forEach(player -> {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncTrophyConfigsPacket(Trophy.getTrophies()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                OpenBlocksTrophies.LOGGER.debug("Sent {} trophy configs to {} from server.", (Object)Trophy.getTrophies().size(), (Object)player.getDisplayName().getString());
            });
        }
    }

    public static void grantAdvancementBasedTrophies(AdvancementEvent.AdvancementEarnEvent event) {
        if (ModList.get().isLoaded("the_bumblezone")) {
            ItemStack trophy;
            if (event.getAdvancement().id().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"the_bumblezone/the_queens_desire/journeys_end"))) {
                trophy = TrophyItem.loadEntityToTrophy(Objects.requireNonNull((EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"bee_queen"))));
                if (event.getEntity().addItem(trophy)) {
                    event.getEntity().drop(trophy, false);
                }
            }
            if (event.getAdvancement().id().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"the_bumblezone/beehemoth/queen_beehemoth"))) {
                trophy = TrophyItem.loadVariantToTrophy(Objects.requireNonNull((EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"beehemoth"))), (CompoundTag)Util.make((Object)new CompoundTag(), tag -> tag.putBoolean("queen", true)));
                if (event.getEntity().addItem(trophy)) {
                    event.getEntity().drop(trophy, false);
                }
            }
        }
    }

    public static void maybeDropTrophy(LivingDropsEvent event) {
        if (!event.getEntity().level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT) || !event.getEntity().shouldDropLoot()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            double dropChance;
            Creeper creeper;
            Player player = (Player)livingEntity;
            Entity entity = event.getSource().getEntity();
            if (entity instanceof Creeper && (creeper = (Creeper)entity).isPowered() && TrophyConfig.playerChargedCreeperDropChance > 0.0) {
                dropChance = TrophyConfig.playerChargedCreeperDropChance - TROPHY_RANDOM.nextDouble();
            } else {
                if (!(event.getSource().getEntity() instanceof Player) && TrophyConfig.trophyDropSource != TrophyConfig.TrophySourceDrop.ALL) {
                    return;
                }
                if (event.getSource().getEntity() instanceof FakePlayer && TrophyConfig.trophyDropSource != TrophyConfig.TrophySourceDrop.FAKE_PLAYER) {
                    return;
                }
                Trophy trophy = Trophy.getTrophies().getOrDefault(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.PLAYER), new Trophy.Builder(EntityType.PLAYER).build());
                dropChance = ((double)TrophyEvents.getLootingLevel((ServerLevel)event.getEntity().level(), event.getSource()) + TROPHY_RANDOM.nextDouble() / 4.0) * OpenBlocksTrophies.getTrophyDropChance(trophy) - TROPHY_RANDOM.nextDouble();
            }
            if (dropChance > 0.0) {
                ItemStack stack = TrophyItem.loadEntityToTrophy(EntityType.PLAYER);
                stack.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)player.getDisplayName().getString()));
                event.getDrops().add(new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), stack));
            }
        } else {
            double chance;
            Trophy trophy;
            if (!(event.getSource().getEntity() instanceof Player) && TrophyConfig.trophyDropSource != TrophyConfig.TrophySourceDrop.ALL) {
                return;
            }
            if (event.getSource().getEntity() instanceof FakePlayer && TrophyConfig.trophyDropSource != TrophyConfig.TrophySourceDrop.FAKE_PLAYER) {
                return;
            }
            if (Trophy.getTrophies().containsKey(BuiltInRegistries.ENTITY_TYPE.getKey((Object)event.getEntity().getType())) && (trophy = Trophy.getTrophies().get(BuiltInRegistries.ENTITY_TYPE.getKey((Object)event.getEntity().getType()))) != null && (chance = ((double)TrophyEvents.getLootingLevel((ServerLevel)event.getEntity().level(), event.getSource()) + TROPHY_RANDOM.nextDouble() / 4.0) * OpenBlocksTrophies.getTrophyDropChance(trophy) - TROPHY_RANDOM.nextDouble()) > 0.0) {
                event.getDrops().add(new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), TrophyItem.loadVariantToTrophy(trophy.type(), TrophyEvents.fetchVariantIfAny(event.getEntity(), trophy))));
            }
        }
    }

    private static int getLootingLevel(ServerLevel level, DamageSource source) {
        AtomicInteger looting = new AtomicInteger();
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            EnchantmentHelper.runIterationOnEquipment((LivingEntity)living, (enchantment, i, item) -> {
                LootContext lootcontext = Enchantment.damageContext((ServerLevel)level, (int)i, (Entity)living, (DamageSource)source);
                ((Enchantment)enchantment.value()).getEffects(EnchantmentEffectComponents.EQUIPMENT_DROPS).forEach(effect -> {
                    if (effect.enchanted() == EnchantmentTarget.ATTACKER && effect.affected() == EnchantmentTarget.VICTIM && effect.matches(lootcontext)) {
                        looting.addAndGet(i);
                    }
                });
            });
        }
        return looting.get();
    }

    private static CompoundTag fetchVariantIfAny(LivingEntity entity, Trophy trophy) {
        if (!trophy.getVariants((HolderLookup.Provider)entity.level().registryAccess()).isEmpty()) {
            CompoundTag tag = new CompoundTag();
            entity.addAdditionalSaveData(tag);
            for (int i = 0; i < trophy.getVariants((HolderLookup.Provider)entity.level().registryAccess()).size(); ++i) {
                CompoundTag variantKeys = trophy.getVariants((HolderLookup.Provider)entity.level().registryAccess()).get(i);
                for (String s : variantKeys.getAllKeys()) {
                    if (entity instanceof VillagerDataHolder) {
                        VillagerDataHolder villager = (VillagerDataHolder)entity;
                        if (!BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)villager.getVillagerData().getProfession()).toString().equals(variantKeys.getString(s))) continue;
                        return variantKeys;
                    }
                    Tag tagVer = tag.get(s);
                    Tag variantVer = variantKeys.get(s);
                    if (variantVer instanceof NumericTag) {
                        NumericTag number;
                        NumericTag num = (NumericTag)variantVer;
                        if (!(tagVer instanceof NumericTag) || (number = (NumericTag)tagVer).getAsLong() != num.getAsLong()) continue;
                        return variantKeys;
                    }
                    if (!Objects.equals(tagVer, variantVer)) continue;
                    return variantKeys;
                }
            }
        }
        return new CompoundTag();
    }
}

