/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.misc;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.mojang.datafixers.util.Pair;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.neoforged.fml.util.ObfuscationReflectionHelper;

public class AmbientSoundFetcher {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Method Mob_getAmbientSound = ObfuscationReflectionHelper.findMethod(Mob.class, (String)"getAmbientSound", (Class[])new Class[0]);
    private static final MethodHandle handle_Mob_getAmbientSound;
    private static final Map<EntityType<?>, Pair<SoundEvent, Float>> SOUND_CACHE;

    public static Pair<SoundEvent, Float> getAmbientSoundAndPitch(EntityType<?> type, Level level) {
        if (!SOUND_CACHE.containsKey(type)) {
            SoundEvent sound = null;
            float pitch = 1.0f;
            Entity entity = type.create(level);
            if (handle_Mob_getAmbientSound != null && entity instanceof Mob) {
                Mob mob = (Mob)entity;
                try {
                    sound = handle_Mob_getAmbientSound.invokeExact(mob);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                pitch = living.getVoicePitch();
            }
            Pair pair = Pair.of(sound, (Object)Float.valueOf(pitch));
            SOUND_CACHE.put(type, (Pair<SoundEvent, Float>)pair);
            return pair;
        }
        return SOUND_CACHE.get(type);
    }

    static {
        SOUND_CACHE = new HashMap();
        MethodHandle tmp_handle_Mob_getAmbientSound = null;
        try {
            tmp_handle_Mob_getAmbientSound = LOOKUP.unreflect(Mob_getAmbientSound);
        }
        catch (IllegalAccessException e) {
            OpenBlocksTrophies.LOGGER.error("Could not unreflect mob ambient sounds: ", (Throwable)e);
        }
        handle_Mob_getAmbientSound = tmp_handle_Mob_getAmbientSound;
    }
}

