/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.item;

import com.gizmo.trophies.misc.TrophyRegistries;
import com.gizmo.trophies.trophy.DisplayTrophy;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class DisplayTrophyItem
extends BlockItem {
    public DisplayTrophyItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Nullable
    public static DisplayTrophy getTrophy(@Nonnull ItemStack stack) {
        if (stack.has(TrophyRegistries.DISPLAY_TROPHY_INFO)) {
            return (DisplayTrophy)stack.get(TrophyRegistries.DISPLAY_TROPHY_INFO);
        }
        return null;
    }

    public Component getName(ItemStack stack) {
        DisplayTrophy trophy = DisplayTrophyItem.getTrophy(stack);
        if (trophy != null) {
            return Component.translatable((String)"block.obtrophies.display_trophy.display", (Object[])new Object[]{trophy.displayItem().getDescription().plainCopy().getString()});
        }
        return super.getName(stack);
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }
}

