/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.data;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.trophy.Trophy;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.ToIntFunction;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.common.conditions.WithConditions;
import org.apache.logging.log4j.Logger;

public abstract class TrophyProvider
implements DataProvider {
    private static final ToIntFunction<String> FIXED_ORDER_FIELDS = (ToIntFunction)Util.make((Object)new Object2IntOpenHashMap(), map -> {
        map.put((Object)"neoforge:conditions", -1);
        map.put((Object)"type", 0);
        map.put((Object)"replace", 1);
        map.put((Object)"entity", 2);
        map.defaultReturnValue(3);
    });
    private static final Comparator<String> KEY_COMPARATOR = Comparator.comparingInt(FIXED_ORDER_FIELDS).thenComparing(s -> s);
    protected final Map<ResourceLocation, Trophy.Builder> builder = Maps.newLinkedHashMap();
    private final String modid;
    private final PackOutput.PathProvider entryPath;

    public TrophyProvider(PackOutput output, String modid) {
        this.modid = modid;
        this.entryPath = output.createPathProvider(PackOutput.Target.DATA_PACK, "trophies");
    }

    public CompletableFuture<?> run(CachedOutput output) {
        HashMap map = Maps.newHashMap();
        this.builder.clear();
        this.createTrophies();
        map.putAll(this.builder);
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        for (Map.Entry entry : map.entrySet()) {
            Path path = this.entryPath.json((ResourceLocation)entry.getKey());
            futuresBuilder.add(this.saveTrophy(output, (JsonElement)Trophy.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, Optional.of(new WithConditions(((Trophy.Builder)entry.getValue()).conditions, (Object)((Trophy.Builder)entry.getValue()).build()))).resultOrPartial(arg_0 -> ((Logger)OpenBlocksTrophies.LOGGER).error(arg_0)).orElseThrow(), path));
        }
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    protected abstract void createTrophies();

    protected void makeTrophy(Trophy.Builder trophy) {
        this.builder.putIfAbsent(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)Objects.requireNonNull(BuiltInRegistries.ENTITY_TYPE.getKey(trophy.build().type())).getPath()), trophy);
    }

    public String getName() {
        return this.modid + " Trophies";
    }

    private CompletableFuture<?> saveTrophy(CachedOutput p_253653_, JsonElement p_254542_, Path p_254467_) {
        return CompletableFuture.runAsync(() -> {
            try {
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                HashingOutputStream hashingoutputstream = new HashingOutputStream(Hashing.sha1(), (OutputStream)bytearrayoutputstream);
                try (JsonWriter jsonwriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)hashingoutputstream, StandardCharsets.UTF_8));){
                    jsonwriter.setSerializeNulls(false);
                    jsonwriter.setIndent("  ");
                    GsonHelper.writeValue((JsonWriter)jsonwriter, (JsonElement)p_254542_, KEY_COMPARATOR);
                }
                p_253653_.writeIfNeeded(p_254467_, bytearrayoutputstream.toByteArray(), hashingoutputstream.hash());
            }
            catch (IOException ioexception) {
                LOGGER.error("Failed to save file to {}", (Object)p_254467_, (Object)ioexception);
            }
        }, Util.backgroundExecutor());
    }
}

