/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.data;

import com.gizmo.trophies.misc.TranslatableStrings;
import com.gizmo.trophies.misc.TrophyRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class LangGenerator
extends LanguageProvider {
    public LangGenerator(PackOutput output) {
        super(output, "obtrophies", "en_us");
    }

    protected void addTranslations() {
        this.addAdvancement("root", "OpenBlocks Trophies", "Challenges revolving around trophy collection");
        this.addAdvancement("one_trophy", "What a find!", "Collect a trophy dropped by a mob. How lucky!");
        this.addAdvancement("boss_trophy", "The True Reward", "Collect a trophy dropped by a boss or miniboss");
        this.addAdvancement("rarest_trophy", "Exotic Artifact Hunter", "Collect the rarest trophy: the Blue Axolotl trophy");
        this.addAdvancement("all_horse_trophies", "Horsin' Around", "Collect every single horse variant as a trophy");
        this.addAdvancement("all_fish_trophies", "Fish Slapped", "Collect all 22 common fish trophies");
        this.addAdvancement("all_vanilla", "The Grand Collector", "Collect a trophy from every single vanilla mob!");
        this.add("obtrophies.configuration.title", "OpenBlocks Trophies Config");
        this.add("obtrophies.configuration.section.obtrophies.client.toml", "Client Settings");
        this.add("obtrophies.configuration.section.obtrophies.client.toml.title", "Client Settings");
        this.add("obtrophies.configuration.section.obtrophies.common.toml", "Common Settings");
        this.add("obtrophies.configuration.section.obtrophies.common.toml.title", "Common Settings");
        this.configEntry("render_names", "Render Player Names", "If true, player trophies will render their names over their head similar to how players do.");
        this.configEntry("render_name_decorators", "Render Player Name Deco", "If true, some player trophies will render with special icons or name colors.\nIf you find this to be too distracting for some reason, you can turn this off to keep the names plainly formatted.");
        this.configEntry("drop_chance", "Global Trophy Drop Chance", "The chance a trophy will drop from its respective mob.\nAll trophy drop chances are defined in their trophy json, but if you want to override that chance without going through and changing every json this is for you.\nThis value works as a percentage (number * 100), so 0.2 would be a 20% chance for example.\nSet this value to any negative number to disable the override.");
        this.configEntry("right_click_override", "Global Right Click Override", "If true, certain trophies will not do special things when right clicked.\nThis can already be changed per trophy with a datapack, but this config option remains for those who want to disable all right click behaviors for every trophy.\nNote that this will not affect mobs playing sounds when right clicked, just behaviors like the squid spawning water or rabbits dropping carrots.");
        this.configEntry("player_creeper_chance", "Player Trophy Drop Chance", "The chance a player will drop a trophy when killed by a charged creeper.\nThis config mostly exists for singleplayer worlds where getting a player kill on a player is rather difficult.\nThis value works as a percentage (number * 100), so 0.2 would be a 20% chance for example.\nSet this value to 0.0 to disable drops from charged creeper kills.");
        this.configEntry("trophy_source_drop", "Trophy Drop Source", "Determines what damage source a mob needs to be killed by in order to have a chance to drop a trophy. The following values are allowed:\nALL: allows trophies to drop whenever a mob dies. This can be to fall damage, another mob, etc.\nFAKE_PLAYER: allows trophies to drop from players and fake players. This can allow mob grinders from other mobs to drop trophies, such as the mob masher from MobGrindingUtils.\nPLAYER: only player kills will drop trophies.");
        this.add("config.obtrophies.source_drop.all", "Any Kill");
        this.add("config.obtrophies.source_drop.fake_player", "(Fake) Player Kill");
        this.add("config.obtrophies.source_drop.player", "Player Kill Only");
        this.add((Block)TrophyRegistries.TROPHY.get(), "Trophy");
        this.add(TranslatableStrings.TROPHY_WITH_ENTITY, "%s Trophy");
        this.add((Block)TrophyRegistries.DISPLAY_TROPHY.get(), "Display Trophy");
        this.add(TranslatableStrings.DISPLAY_TROPHY, "%s Trophy");
        this.add("command.obtrophies.count", "Trophy Count: %s");
        this.add("command.obtrophies.empty_list", "Trophy list is not populated!");
        this.add("command.obtrophies.mod_not_loaded", "Mod %s does not exist!");
        this.add("command.obtrophies.place", "Placed %s Trophies");
        this.add("command.obtrophies.trophy_made", "Trophy stub made for entity %s");
        this.add("command.obtrophies.trophies_made", "Sucessfully made %s trophy configs!");
        this.add(TranslatableStrings.FROM_MOD_ID, "From: %s");
        this.add(TranslatableStrings.VARIANT_FORMATTER, "\"%s\": \"%s\"");
        this.add("itemGroup.obtrophies", "Trophies");
        this.add("gui.obtrophies.drop_chance", "Chance: %s%%");
        this.add("gui.obtrophies.fake_player_drops", "(fake players count)");
        this.add("gui.obtrophies.player_drops", "Drops on player kill only");
        this.add("gui.obtrophies.trophy_category", "Trophy Drops");
        this.add("emi.category.obtrophies.trophy", "Trophy Drops");
    }

    public void addAdvancement(String key, String title, String desc) {
        this.add("advancement.obtrophies." + key + ".title", title);
        this.add("advancement.obtrophies." + key + ".desc", desc);
    }

    public void configEntry(String key, String name, String description) {
        this.add("config.obtrophies." + key, name);
        this.add("config.obtrophies." + key + ".tooltip", description);
    }
}

