/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.config;

import com.gizmo.trophies.config.TrophyClientConfig;
import com.gizmo.trophies.config.TrophyCommonConfig;
import com.gizmo.trophies.network.SyncCommonConfigPacket;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ByIdMap;
import net.neoforged.neoforge.common.TranslatableEnum;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class TrophyConfig {
    public static boolean playersRenderNames = true;
    public static boolean renderNameColorsAndIcons = true;
    public static TrophySourceDrop trophyDropSource = TrophySourceDrop.PLAYER;
    public static boolean rightClickEffectOverride = false;
    public static double dropChanceOverride = -1.0;
    public static double playerChargedCreeperDropChance = 0.2;

    static void rebakeClientOptions(TrophyClientConfig config) {
        playersRenderNames = (Boolean)config.playersRenderNames.get();
        renderNameColorsAndIcons = (Boolean)config.renderNameColorsAndIcons.get();
    }

    static void rebakeCommonOptions(TrophyCommonConfig config) {
        trophyDropSource = (TrophySourceDrop)((Object)config.trophyDropSource.get());
        rightClickEffectOverride = (Boolean)config.rightClickEffectOverride.get();
        dropChanceOverride = (Double)config.dropChanceOverride.get();
        playerChargedCreeperDropChance = (Double)config.playerChargedCreeperDropChance.get();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && server.isDedicatedServer()) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncCommonConfigPacket(trophyDropSource), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static enum TrophySourceDrop implements TranslatableEnum
    {
        ALL,
        FAKE_PLAYER,
        PLAYER;

        public static final IntFunction<TrophySourceDrop> BY_ID;
        public static final StreamCodec<ByteBuf, TrophySourceDrop> STREAM_CODEC;

        public Component getTranslatedName() {
            return Component.translatable((String)("config.obtrophies.source_drop." + this.name().toLowerCase(Locale.ROOT)));
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])TrophySourceDrop.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

