/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.config;

import com.gizmo.trophies.config.TrophyConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class TrophyCommonConfig {
    final ModConfigSpec.EnumValue<TrophyConfig.TrophySourceDrop> trophyDropSource;
    final ModConfigSpec.BooleanValue rightClickEffectOverride;
    final ModConfigSpec.DoubleValue dropChanceOverride;
    final ModConfigSpec.DoubleValue playerChargedCreeperDropChance;

    public TrophyCommonConfig(ModConfigSpec.Builder builder) {
        this.trophyDropSource = builder.translation("config.obtrophies.trophy_source_drop").comment("Determines what damage source a mob needs to be killed by in order to have a chance to drop a trophy. The following values are allowed:\nALL: allows trophies to drop whenever a mob dies. This can be to fall damage, another mob, etc.\nFAKE_PLAYER: allows trophies to drop from players and fake players. This can allow mob grinders from other mobs to drop trophies, such as the mob masher from MobGrindingUtils.\nPLAYER: only player kills will drop trophies.").defineEnum("trophySourceDrop", (Enum)TrophyConfig.TrophySourceDrop.PLAYER);
        this.rightClickEffectOverride = builder.translation("config.obtrophies.right_click_override").comment("If true, certain trophies will not do special things when right clicked.\nThis can already be changed per trophy with a datapack, but this config option remains for those who want to disable all right click behaviors for every trophy.\nNote that this will not affect mobs playing sounds when right clicked, just behaviors like the squid spawning water or rabbits dropping carrots.").define("globalRightClickOverride", false);
        this.dropChanceOverride = builder.translation("config.obtrophies.drop_chance").comment("The chance a trophy will drop from its respective mob.\nAll trophy drop chances are defined in their trophy json, but if you want to override that chance without going through and changing every json this is for you.\nThis value works as a percentage (number * 100), so 0.2 would be a 20% chance for example.\nSet this value to any negative number to disable the override.").defineInRange("globalTrophyDropOverride", -1.0, -1.0, 1.0);
        this.playerChargedCreeperDropChance = builder.translation("config.obtrophies.player_creeper_chance").comment("The chance a player will drop a trophy when killed by a charged creeper.\nThis config mostly exists for singleplayer worlds where getting a player kill on a player is rather difficult.\nThis value works as a percentage (number * 100), so 0.2 would be a 20% chance for example.\nSet this value to 0.0 to disable drops from charged creeper kills.").defineInRange("chargedCreeperPlayerTrophyChance", 0.2, 0.0, 1.0);
    }
}

