/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.config;

import com.gizmo.trophies.config.TrophyClientConfig;
import com.gizmo.trophies.config.TrophyCommonConfig;
import com.gizmo.trophies.config.TrophyConfig;
import com.gizmo.trophies.network.SyncCommonConfigPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigSetup {
    private static final ModConfigSpec CLIENT_SPEC;
    private static final ModConfigSpec COMMON_SPEC;
    private static final TrophyClientConfig CLIENT_CONFIG;
    private static final TrophyCommonConfig COMMON_CONFIG;

    public static void loadConfigs(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == CLIENT_SPEC) {
            TrophyConfig.rebakeClientOptions(CLIENT_CONFIG);
        } else if (event.getConfig().getSpec() == COMMON_SPEC) {
            TrophyConfig.rebakeCommonOptions(COMMON_CONFIG);
        }
    }

    public static void reloadConfigs(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == CLIENT_SPEC) {
            TrophyConfig.rebakeClientOptions(CLIENT_CONFIG);
        } else if (event.getConfig().getSpec() == COMMON_SPEC) {
            TrophyConfig.rebakeCommonOptions(COMMON_CONFIG);
        }
    }

    public static void syncConfigOnLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && server.isDedicatedServer() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SyncCommonConfigPacket(TrophyConfig.trophyDropSource), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(TrophyCommonConfig::new);
        COMMON_SPEC = (ModConfigSpec)specPair.getRight();
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC);
        COMMON_CONFIG = (TrophyCommonConfig)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(TrophyClientConfig::new);
        CLIENT_SPEC = (ModConfigSpec)specPair.getRight();
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
        CLIENT_CONFIG = (TrophyClientConfig)specPair.getLeft();
    }
}

