/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.compat.jei;

import com.gizmo.trophies.block.TrophyInfo;
import com.gizmo.trophies.misc.TrophyRegistries;
import java.util.ArrayList;
import java.util.StringJoiner;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class TrophyVariantInterpreter
implements IIngredientSubtypeInterpreter<ItemStack> {
    public static final TrophyVariantInterpreter INSTANCE = new TrophyVariantInterpreter();

    public String apply(ItemStack stack, UidContext context) {
        if (stack.getComponentsPatch().isEmpty()) {
            return "";
        }
        TrophyInfo info = (TrophyInfo)stack.getOrDefault(TrophyRegistries.TROPHY_INFO, (Object)TrophyInfo.DEFAULT);
        String itemDescriptionId = stack.getItem().getDescriptionId();
        String entityDescriptionId = info.type().getDescriptionId();
        CompoundTag tag = info.variant().orElse(new CompoundTag());
        ArrayList<String> strings = new ArrayList<String>();
        for (String key : tag.getAllKeys()) {
            Tag value = tag.get(key);
            if (value == null) continue;
            strings.add(value.getAsString().replace(':', '_'));
        }
        StringJoiner joiner = new StringJoiner(",", "[", "]");
        strings.sort(null);
        for (String s : strings) {
            joiner.add(s);
        }
        return itemDescriptionId + "." + entityDescriptionId + ".variant." + String.valueOf(joiner);
    }
}

