/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.compat.jei;

import com.gizmo.trophies.compat.TrophyRecipeViewerConstants;
import com.gizmo.trophies.compat.jei.JEICompat;
import com.gizmo.trophies.compat.jei.TrophyInfoWrapper;
import com.gizmo.trophies.config.TrophyConfig;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.commons.lang3.StringUtils;

public class TrophyCategory
implements IRecipeCategory<TrophyInfoWrapper> {
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable fakePlayerIcon;
    private final IDrawable playerIcon;
    private final IDrawable arrowIcon;
    private final Component localizedName;

    public TrophyCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TrophyRecipeViewerConstants.BACKGROUND, 0, 0, 116, 54);
        this.fakePlayerIcon = helper.createDrawable(TrophyRecipeViewerConstants.BACKGROUND, 116, 0, 16, 16);
        this.playerIcon = helper.createDrawable(TrophyRecipeViewerConstants.BACKGROUND, 116, 16, 16, 16);
        this.arrowIcon = helper.createDrawable(TrophyRecipeViewerConstants.BACKGROUND, 116, 32, 23, 15);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)Items.DIAMOND_SWORD.getDefaultInstance());
        this.localizedName = Component.translatable((String)"gui.obtrophies.trophy_category");
    }

    public RecipeType<TrophyInfoWrapper> getRecipeType() {
        return JEICompat.TROPHY;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(TrophyInfoWrapper recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        TrophyRecipeViewerConstants.renderEntity(graphics, recipe.getTrophyEntity(), 25, 42, recipe.variant(), recipe.getDefaultTrophyVariant());
        switch (TrophyConfig.trophyDropSource) {
            case ALL: {
                this.arrowIcon.draw(graphics, 50, 19);
                break;
            }
            case FAKE_PLAYER: {
                this.fakePlayerIcon.draw(graphics, 54, 19);
                break;
            }
            case PLAYER: {
                this.playerIcon.draw(graphics, 54, 19);
            }
        }
        if (mouseX > 8.0 && mouseX < 43.0 && mouseY > 9.0 && mouseY < 44.0) {
            AbstractContainerScreen.renderSlotHighlight((GuiGraphics)graphics, (int)10, (int)11, (int)0);
            AbstractContainerScreen.renderSlotHighlight((GuiGraphics)graphics, (int)26, (int)11, (int)0);
            AbstractContainerScreen.renderSlotHighlight((GuiGraphics)graphics, (int)10, (int)27, (int)0);
            AbstractContainerScreen.renderSlotHighlight((GuiGraphics)graphics, (int)26, (int)27, (int)0);
        }
        graphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"gui.obtrophies.drop_chance", (Object[])new Object[]{TrophyRecipeViewerConstants.getTrophyDropPercentage(recipe.trophy())}), 46, 45, -8355712, false);
    }

    public List<Component> getTooltipStrings(TrophyInfoWrapper recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (mouseX > 8.0 && mouseX < 43.0 && mouseY > 9.0 && mouseY < 44.0) {
            components.add(recipe.getTrophyEntity().getDescription());
            if (Minecraft.getInstance().options.advancedItemTooltips) {
                components.add((Component)Component.literal((String)BuiltInRegistries.ENTITY_TYPE.getKey(recipe.getTrophyEntity()).toString()).withStyle(ChatFormatting.DARK_GRAY));
            }
            components.add((Component)Component.literal((String)this.getModIdForTooltip(BuiltInRegistries.ENTITY_TYPE.getKey(recipe.getTrophyEntity()).getNamespace())).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        }
        if (mouseX > 51.0 && mouseX < 73.0 && mouseY > 19.0 && mouseY < 34.0 && TrophyConfig.trophyDropSource != TrophyConfig.TrophySourceDrop.ALL) {
            components.add((Component)Component.translatable((String)"gui.obtrophies.player_drops").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            if (TrophyConfig.trophyDropSource == TrophyConfig.TrophySourceDrop.FAKE_PLAYER) {
                components.add((Component)Component.translatable((String)"gui.obtrophies.fake_player_drops").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            }
        }
        return components;
    }

    private String getModIdForTooltip(String modId) {
        return ModList.get().getModContainerById(modId).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElseGet(() -> StringUtils.capitalize((String)modId));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TrophyInfoWrapper recipe, IFocusGroup focuses) {
        SpawnEggItem egg = DeferredSpawnEggItem.byId(recipe.getTrophyEntity());
        if (egg != null) {
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(new ItemStack((ItemLike)egg));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 86, 19).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.getTrophyItem());
    }
}

