/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.compat.jei;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.compat.jei.TrophyCategory;
import com.gizmo.trophies.compat.jei.TrophyInfoWrapper;
import com.gizmo.trophies.compat.jei.TrophyVariantInterpreter;
import com.gizmo.trophies.item.TrophyItem;
import com.gizmo.trophies.misc.TrophyRegistries;
import com.gizmo.trophies.trophy.Trophy;
import java.util.LinkedList;
import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    public static final RecipeType<TrophyInfoWrapper> TROPHY = RecipeType.create((String)"obtrophies", (String)"trophy", TrophyInfoWrapper.class);

    public ResourceLocation getPluginUid() {
        return OpenBlocksTrophies.prefix("trophies");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new TrophyCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(TrophyItem.createCyclingTrophy(EntityType.CHICKEN), new RecipeType[]{TROPHY});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        LinkedList<TrophyInfoWrapper> trophies = new LinkedList<TrophyInfoWrapper>();
        if (!Trophy.getTrophies().isEmpty()) {
            for (Map.Entry<ResourceLocation, Trophy> trophyEntry : Trophy.getTrophies().entrySet()) {
                if (trophyEntry.getValue().type() == EntityType.PLAYER || OpenBlocksTrophies.getTrophyDropChance(trophyEntry.getValue()) <= 0.0) continue;
                if (!trophyEntry.getValue().getVariants((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()).isEmpty()) {
                    for (CompoundTag variant : trophyEntry.getValue().getVariants((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())) {
                        trophies.add(new TrophyInfoWrapper(trophyEntry.getValue(), variant));
                    }
                    continue;
                }
                trophies.add(new TrophyInfoWrapper(trophyEntry.getValue(), new CompoundTag()));
            }
        }
        registration.addRecipes(TROPHY, trophies);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)TrophyRegistries.TROPHY_ITEM.get(), (IIngredientSubtypeInterpreter)TrophyVariantInterpreter.INSTANCE);
    }
}

