/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.compat.emi;

import com.gizmo.trophies.compat.TrophyRecipeViewerConstants;
import com.gizmo.trophies.compat.emi.EmiCompat;
import com.gizmo.trophies.compat.emi.EmiEntityWidget;
import com.gizmo.trophies.config.TrophyConfig;
import com.gizmo.trophies.item.TrophyItem;
import com.gizmo.trophies.trophy.Trophy;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;

public record EmiTrophyRecipe(ResourceLocation id, Trophy trophy, CompoundTag variant) implements EmiRecipe
{
    public static final EmiTexture BACKGROUND = new EmiTexture(TrophyRecipeViewerConstants.BACKGROUND, 0, 0, 116, 54);
    public static final EmiTexture ANY_SOURCE_INDICATOR = new EmiTexture(TrophyRecipeViewerConstants.BACKGROUND, 116, 32, 23, 15);
    public static final EmiTexture FAKE_PLAYER_INDICATOR = new EmiTexture(TrophyRecipeViewerConstants.BACKGROUND, 116, 0, 16, 16);
    public static final EmiTexture PLAYER_INDICATOR = new EmiTexture(TrophyRecipeViewerConstants.BACKGROUND, 116, 16, 16, 16);

    public EmiRecipeCategory getCategory() {
        return EmiCompat.TROPHY;
    }

    public ResourceLocation getId() {
        return this.id();
    }

    public List<EmiIngredient> getInputs() {
        SpawnEggItem egg = DeferredSpawnEggItem.byId(this.trophy().type());
        if (egg != null) {
            return List.of(EmiStack.of((ItemLike)egg));
        }
        return List.of();
    }

    public List<EmiStack> getOutputs() {
        return List.of(EmiStack.of((ItemStack)TrophyItem.loadVariantToTrophy(this.trophy().type(), this.variant())));
    }

    public int getDisplayWidth() {
        return 116;
    }

    public int getDisplayHeight() {
        return 54;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND, 0, 0);
        widgets.add((Widget)new EmiEntityWidget(this.trophy().type(), 10, 11, 32, this.variant(), this.trophy().defaultData()));
        if (TrophyConfig.trophyDropSource != TrophyConfig.TrophySourceDrop.ALL) {
            widgets.addTexture(this.getKillIcon(), 54, 19);
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            components.add(Component.translatable((String)"gui.obtrophies.player_drops").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            if (TrophyConfig.trophyDropSource == TrophyConfig.TrophySourceDrop.FAKE_PLAYER) {
                components.add(Component.translatable((String)"gui.obtrophies.fake_player_drops").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            }
            widgets.addTooltipText(components, 54, 19, 16, 16);
        } else {
            widgets.addTexture(this.getKillIcon(), 50, 19);
        }
        widgets.addText((Component)Component.translatable((String)"gui.obtrophies.drop_chance", (Object[])new Object[]{TrophyRecipeViewerConstants.getTrophyDropPercentage(this.trophy())}), 46, 45, -8355712, false);
        widgets.addSlot((EmiIngredient)this.getOutputs().getFirst(), 81, 14).large(true).drawBack(false);
    }

    private EmiTexture getKillIcon() {
        return switch (TrophyConfig.trophyDropSource) {
            default -> throw new MatchException(null, null);
            case TrophyConfig.TrophySourceDrop.ALL -> ANY_SOURCE_INDICATOR;
            case TrophyConfig.TrophySourceDrop.FAKE_PLAYER -> FAKE_PLAYER_INDICATOR;
            case TrophyConfig.TrophySourceDrop.PLAYER -> PLAYER_INDICATOR;
        };
    }

    public boolean supportsRecipeTree() {
        return false;
    }
}

