/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.compat;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.client.EntityCache;
import com.gizmo.trophies.trophy.Trophy;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public final class TrophyRecipeViewerConstants {
    public static final ResourceLocation BACKGROUND = OpenBlocksTrophies.prefix("textures/gui/trophy_jei.png");
    public static final int WIDTH = 116;
    public static final int HEIGHT = 54;
    public static final Component PLAYER_DROP_ONLY = Component.translatable((String)"gui.obtrophies.jei.player_drops").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY});
    public static final Component FAKE_PLAYER_DROPS = Component.translatable((String)"gui.obtrophies.jei.fake_player_drops").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY});

    public static double getTrophyDropPercentage(Trophy trophy) {
        return OpenBlocksTrophies.getTrophyDropChance(trophy) * 100.0;
    }

    public static void renderEntity(GuiGraphics graphics, @Nullable EntityType<?> type, int x, int y, CompoundTag variant, Optional<CompoundTag> defaultVariant) {
        LivingEntity entity;
        if (type != null && (entity = EntityCache.fetchEntity(type, (Level)Minecraft.getInstance().level, variant, defaultVariant)) != null) {
            int scale = 16;
            float height = entity.getBbHeight();
            float width = entity.getBbWidth();
            if (height <= 0.5f && width < 0.75f) {
                scale = (int)(Math.max(height, width) * 48.0f);
            } else if (height < 1.0f && width < 0.75f) {
                scale = (int)(Math.max(height, width) * 32.0f);
            } else if (height > 2.0f) {
                scale = (int)(32.0f / Math.max(height, width));
            }
            try {
                TrophyRecipeViewerConstants.renderTheEntity(graphics, x, y, scale, entity);
            }
            catch (Exception e) {
                OpenBlocksTrophies.LOGGER.error("Error drawing entity {}", (Object)BuiltInRegistries.ENTITY_TYPE.getKey(type), (Object)e);
                EntityCache.addEntityToBlacklist(type);
            }
        }
    }

    private static void renderTheEntity(GuiGraphics graphics, int x, int y, int scale, LivingEntity entity) {
        PoseStack posestack = graphics.pose();
        Quaternionf quaternion = Axis.ZP.rotationDegrees(180.0f);
        Quaternionf quaternion1 = Axis.XP.rotationDegrees(20.0f);
        quaternion.mul((Quaternionfc)quaternion1);
        float f2 = entity.yBodyRot;
        float f3 = entity.getYRot();
        float f4 = entity.getXRot();
        float f5 = entity.yHeadRotO;
        float f6 = entity.yHeadRot;
        entity.yBodyRot = 0.0f;
        entity.setYRot(0.0f);
        entity.setXRot(0.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        posestack.pushPose();
        posestack.translate((double)x, (double)y, 50.0);
        TrophyRecipeViewerConstants.applyAdditionalTransforms(entity.getType(), posestack);
        posestack.scale((float)scale, (float)scale, (float)(-scale));
        posestack.mulPose(quaternion);
        posestack.mulPose(Axis.XN.rotationDegrees(35.0f));
        posestack.mulPose(Axis.YN.rotationDegrees(145.0f));
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        quaternion1.conjugate();
        dispatcher.overrideCameraOrientation(quaternion1);
        boolean hitboxes = dispatcher.shouldRenderHitBoxes();
        dispatcher.setRenderShadow(false);
        dispatcher.setRenderHitBoxes(false);
        RenderSystem.runAsFancy(() -> dispatcher.render((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, posestack, (MultiBufferSource)graphics.bufferSource(), 0xF000F0));
        graphics.flush();
        dispatcher.setRenderShadow(true);
        dispatcher.setRenderHitBoxes(hitboxes);
        graphics.pose().popPose();
        Lighting.setupFor3DItems();
        entity.yBodyRot = f2;
        entity.setYRot(f3);
        entity.setXRot(f4);
        entity.yHeadRotO = f5;
        entity.yHeadRot = f6;
    }

    private static void applyAdditionalTransforms(EntityType<?> entity, PoseStack stack) {
        if (entity == EntityType.GHAST) {
            stack.translate(0.0, -12.5, 0.0);
            stack.scale(0.5f, 0.5f, 0.5f);
        }
        if (entity == EntityType.ENDER_DRAGON) {
            stack.translate(0.0, -4.0, 0.0);
            stack.mulPose(Axis.YP.rotationDegrees(180.0f));
            stack.mulPose(Axis.XP.rotationDegrees(-30.0f));
        }
        if (entity == EntityType.WITHER) {
            stack.translate(0.0, 8.0, 0.0);
        }
        if (entity == EntityType.SQUID || entity == EntityType.GLOW_SQUID) {
            stack.translate(0.0, -19.0, 0.0);
        }
        if (entity == EntityType.ELDER_GUARDIAN) {
            stack.scale(0.6f, 0.6f, 0.6f);
        }
    }

    public static List<Component> getMobTooltip(EntityType<?> type) {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(type.getDescription());
        if (Minecraft.getInstance().options.advancedItemTooltips) {
            components.add((Component)Component.literal((String)BuiltInRegistries.ENTITY_TYPE.getKey(type).toString()).withStyle(ChatFormatting.DARK_GRAY));
        }
        return components;
    }

    public static String getModIdForTooltip(String modId) {
        return ModList.get().getModContainerById(modId).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElseGet(() -> StringUtils.capitalize((String)modId));
    }
}

