/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.command;

import com.gizmo.trophies.block.TrophyBlock;
import com.gizmo.trophies.block.entity.TrophyBlockEntity;
import com.gizmo.trophies.command.TrophiesCommands;
import com.gizmo.trophies.misc.TrophyRegistries;
import com.gizmo.trophies.trophy.Trophy;
import com.google.common.collect.Maps;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class PlaceTrophiesCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"placetrophies").requires(cs -> cs.hasPermission(3))).executes(context -> PlaceTrophiesCommand.placeAll((CommandContext<CommandSourceStack>)context, false, "all"))).then(((RequiredArgumentBuilder)Commands.argument((String)"variants", (ArgumentType)BoolArgumentType.bool()).executes(context -> PlaceTrophiesCommand.placeAll((CommandContext<CommandSourceStack>)context, BoolArgumentType.getBool((CommandContext)context, (String)"variants"), "all"))).then(Commands.argument((String)"modid", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest(TrophiesCommands.getLoadedModIds(), (SuggestionsBuilder)builder)).executes(context -> PlaceTrophiesCommand.placeAll((CommandContext<CommandSourceStack>)context, BoolArgumentType.getBool((CommandContext)context, (String)"variants"), StringArgumentType.getString((CommandContext)context, (String)"modid")))));
    }

    public static int placeAll(CommandContext<CommandSourceStack> context, boolean placeVariants, String modid) throws CommandSyntaxException {
        if (Trophy.getTrophies().isEmpty()) {
            throw new SimpleCommandExceptionType((Message)Component.translatable((String)"command.obtrophies.empty_list").withStyle(ChatFormatting.RED)).create();
        }
        TreeMap sortedTrophies = new TreeMap(Comparator.naturalOrder());
        if (!modid.equals("all")) {
            sortedTrophies.putAll(Maps.filterKeys(Trophy.getTrophies(), input -> input.getNamespace().equals(modid)));
        } else {
            sortedTrophies.putAll(Trophy.getTrophies());
        }
        int amount = sortedTrophies.size();
        int sideLength = (int)Math.ceil(Math.sqrt(amount));
        for (int i = 0; i < sideLength; ++i) {
            int index;
            for (int j = 0; j < sideLength && (index = j + i * sideLength) <= amount - 1; ++j) {
                Trophy trophy = (Trophy)((Map.Entry)sortedTrophies.entrySet().stream().toList().get(index)).getValue();
                if (placeVariants && !trophy.getVariants((HolderLookup.Provider)((CommandSourceStack)context.getSource()).getLevel().registryAccess()).isEmpty()) {
                    int yOffs = 0;
                    for (CompoundTag tag : trophy.getVariants((HolderLookup.Provider)((CommandSourceStack)context.getSource()).getLevel().registryAccess())) {
                        BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition()).offset(i, yOffs, j);
                        PlaceTrophiesCommand.setupTrophy((Level)((CommandSourceStack)context.getSource()).getLevel(), pos, trophy, tag);
                        ++yOffs;
                    }
                    continue;
                }
                BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition()).offset(i, 0, j);
                PlaceTrophiesCommand.setupTrophy((Level)((CommandSourceStack)context.getSource()).getLevel(), pos, trophy, null);
            }
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.obtrophies.place", (Object[])new Object[]{amount}), false);
        return 1;
    }

    private static void setupTrophy(Level level, BlockPos pos, Trophy trophy, @Nullable CompoundTag variant) {
        level.setBlockAndUpdate(pos, (BlockState)((Block)TrophyRegistries.TROPHY.get()).defaultBlockState().setValue((Property)TrophyBlock.FACING, (Comparable)Direction.WEST));
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TrophyBlockEntity) {
            TrophyBlockEntity trophyBE = (TrophyBlockEntity)blockEntity;
            trophyBE.setTrophy(trophy);
            if (variant != null) {
                trophyBE.setVariant(variant);
            }
        }
    }
}

