/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.command;

import com.gizmo.trophies.command.TrophiesCommands;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.LevelResource;

public class DumpRegistryCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)Commands.literal((String)"dumpRegistry").then(Commands.argument((String)"registry", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> SharedSuggestionProvider.suggestResource(DumpRegistryCommand.getAllRegistries(((CommandSourceStack)context.getSource()).getLevel()), (SuggestionsBuilder)builder)).then(Commands.argument((String)"dumpToFile", (ArgumentType)BoolArgumentType.bool()).executes(context -> DumpRegistryCommand.forEachRegistry((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.getId((CommandContext)context, (String)"registry"), BoolArgumentType.getBool((CommandContext)context, (String)"dumpToFile")))));
    }

    public static List<ResourceLocation> getAllRegistries(ServerLevel level) {
        ArrayList<ResourceLocation> registries = new ArrayList<ResourceLocation>(level.registryAccess().registries().map(registryEntry -> registryEntry.key().location()).toList());
        registries.addFirst(ResourceLocation.fromNamespaceAndPath((String)"", (String)"all"));
        return registries;
    }

    public static int forEachRegistry(CommandContext<CommandSourceStack> context, ResourceLocation registryName, boolean dumpToFile) {
        if (registryName.toString().equals("all")) {
            DumpRegistryCommand.getAllRegistries(((CommandSourceStack)context.getSource()).getLevel()).forEach(location -> DumpRegistryCommand.getRegistryKeys(context, location, dumpToFile));
        } else {
            DumpRegistryCommand.getRegistryKeys(context, registryName, dumpToFile);
        }
        return 1;
    }

    public static void getRegistryKeys(CommandContext<CommandSourceStack> context, ResourceLocation registryName, boolean dumpToFile) {
        ResourceKey key = ResourceKey.createRegistryKey((ResourceLocation)registryName);
        if (dumpToFile) {
            Path path = ((CommandSourceStack)context.getSource()).getLevel().getServer().getWorldPath(LevelResource.GENERATED_DIR).resolve("registries").resolve(registryName.getNamespace()).resolve(registryName.getPath() + ".json").normalize();
            JsonObject object = new JsonObject();
            JsonArray registryArray = new JsonArray();
            ((CommandSourceStack)context.getSource()).registryAccess().registryOrThrow(key).entrySet().forEach(entry -> registryArray.add(((ResourceKey)entry.getKey()).location().toString()));
            object.add("entries", (JsonElement)registryArray);
            TrophiesCommands.writeToFile((JsonElement)object, path);
        } else {
            ((CommandSourceStack)context.getSource()).registryAccess().registryOrThrow(key).entrySet().forEach(entry -> ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)((ResourceKey)entry.getKey()).location().toString())));
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Registry Size: " + ((CommandSourceStack)context.getSource()).registryAccess().registryOrThrow(key).entrySet().size())));
        }
    }
}

