/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.command;

import com.gizmo.trophies.misc.TrophyRegistries;
import com.gizmo.trophies.trophy.DisplayTrophy;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CreateDisplayTrophyCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register(CommandBuildContext context) {
        return (LiteralArgumentBuilder)Commands.literal((String)"createdisplay").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)context)).executes(commandContext -> CreateDisplayTrophyCommand.createDisplayTrophy((CommandContext<CommandSourceStack>)commandContext, EntityArgument.getPlayers((CommandContext)commandContext, (String)"targets"), ItemArgument.getItem((CommandContext)commandContext, (String)"item").getItem(), 1.0f, Vec3.ZERO, Vec3.ZERO, 0.0f, false, null))).then(((RequiredArgumentBuilder)Commands.argument((String)"scale", (ArgumentType)FloatArgumentType.floatArg()).executes(commandContext -> CreateDisplayTrophyCommand.createDisplayTrophy((CommandContext<CommandSourceStack>)commandContext, EntityArgument.getPlayers((CommandContext)commandContext, (String)"targets"), ItemArgument.getItem((CommandContext)commandContext, (String)"item").getItem(), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"scale"), Vec3.ZERO, Vec3.ZERO, 0.0f, false, null))).then(((RequiredArgumentBuilder)Commands.argument((String)"offset", (ArgumentType)Vec3Argument.vec3((boolean)false)).executes(commandContext -> CreateDisplayTrophyCommand.createDisplayTrophy((CommandContext<CommandSourceStack>)commandContext, EntityArgument.getPlayers((CommandContext)commandContext, (String)"targets"), ItemArgument.getItem((CommandContext)commandContext, (String)"item").getItem(), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"scale"), Vec3Argument.getVec3((CommandContext)commandContext, (String)"offset"), Vec3.ZERO, 0.0f, false, null))).then(((RequiredArgumentBuilder)Commands.argument((String)"rotation", (ArgumentType)Vec3Argument.vec3((boolean)false)).executes(commandContext -> CreateDisplayTrophyCommand.createDisplayTrophy((CommandContext<CommandSourceStack>)commandContext, EntityArgument.getPlayers((CommandContext)commandContext, (String)"targets"), ItemArgument.getItem((CommandContext)commandContext, (String)"item").getItem(), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"scale"), Vec3Argument.getVec3((CommandContext)commandContext, (String)"offset"), Vec3Argument.getVec3((CommandContext)commandContext, (String)"rotation"), 0.0f, false, null))).then(((RequiredArgumentBuilder)Commands.argument((String)"rotation_speed", (ArgumentType)FloatArgumentType.floatArg()).executes(commandContext -> CreateDisplayTrophyCommand.createDisplayTrophy((CommandContext<CommandSourceStack>)commandContext, EntityArgument.getPlayers((CommandContext)commandContext, (String)"targets"), ItemArgument.getItem((CommandContext)commandContext, (String)"item").getItem(), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"scale"), Vec3Argument.getVec3((CommandContext)commandContext, (String)"offset"), Vec3Argument.getVec3((CommandContext)commandContext, (String)"rotation"), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"rotation_speed"), false, null))).then(((RequiredArgumentBuilder)Commands.argument((String)"bob", (ArgumentType)BoolArgumentType.bool()).executes(commandContext -> CreateDisplayTrophyCommand.createDisplayTrophy((CommandContext<CommandSourceStack>)commandContext, EntityArgument.getPlayers((CommandContext)commandContext, (String)"targets"), ItemArgument.getItem((CommandContext)commandContext, (String)"item").getItem(), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"scale"), Vec3Argument.getVec3((CommandContext)commandContext, (String)"offset"), Vec3Argument.getVec3((CommandContext)commandContext, (String)"rotation"), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"rotation_speed"), BoolArgumentType.getBool((CommandContext)commandContext, (String)"bob"), null))).then(Commands.argument((String)"sound", (ArgumentType)ResourceLocationArgument.id()).executes(commandContext -> CreateDisplayTrophyCommand.createDisplayTrophy((CommandContext<CommandSourceStack>)commandContext, EntityArgument.getPlayers((CommandContext)commandContext, (String)"targets"), ItemArgument.getItem((CommandContext)commandContext, (String)"item").getItem(), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"scale"), Vec3Argument.getVec3((CommandContext)commandContext, (String)"offset"), Vec3Argument.getVec3((CommandContext)commandContext, (String)"rotation"), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"rotation_speed"), BoolArgumentType.getBool((CommandContext)commandContext, (String)"bob"), ResourceLocationArgument.getId((CommandContext)commandContext, (String)"sound")))))))))));
    }

    public static int createDisplayTrophy(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> targets, Item displayItem, float scale, Vec3 offset, Vec3 rotation, float rotationSpeed, boolean bob, @Nullable ResourceLocation rightClickSound) {
        DisplayTrophy trophy = new DisplayTrophy(displayItem, scale, offset, rotation, rotationSpeed, bob, Optional.ofNullable((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(rightClickSound)));
        for (ServerPlayer serverplayer : targets) {
            ItemEntity itementity;
            ItemStack newStack = new ItemStack((ItemLike)TrophyRegistries.DISPLAY_TROPHY_ITEM.get());
            newStack.set(TrophyRegistries.DISPLAY_TROPHY_INFO, (Object)trophy);
            newStack.set(DataComponents.RARITY, (Object)trophy.displayItem().getDefaultInstance().getRarity());
            if (!serverplayer.getInventory().add(newStack) || (itementity = serverplayer.drop(newStack, false)) == null) continue;
            itementity.setNoPickUpDelay();
            itementity.setTarget(serverplayer.getUUID());
        }
        return targets.size();
    }
}

