/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.client;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class VariantToggleButton
extends Button {
    private static final ResourceLocation CHECKBOX_SELECTED_HOVERED_SPRITE = OpenBlocksTrophies.prefix("textures/gui/sprites/check_box_selected_hovered.png");
    private static final ResourceLocation CHECKBOX_SELECTED_SPRITE = OpenBlocksTrophies.prefix("textures/gui/sprites/check_box_selected.png");
    private static final ResourceLocation CHECKBOX_HOVERED_SPRITE = OpenBlocksTrophies.prefix("textures/gui/sprites/check_box_hovered.png");
    private static final ResourceLocation CHECKBOX_SPRITE = OpenBlocksTrophies.prefix("textures/gui/sprites/check_box.png");
    private boolean selected;

    public VariantToggleButton(int x, int y, Component message, boolean selected, Button.OnPress press) {
        super(x, y, 12, 12, message, press, Supplier::get);
        this.selected = selected;
    }

    public void onPress() {
        this.selected = !this.selected;
        super.onPress();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
        output.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            if (this.isFocused()) {
                output.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.focused"));
            } else {
                output.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.hovered"));
            }
        }
    }

    public void renderWidget(GuiGraphics graphics, int x, int y, float partialTicks) {
        RenderSystem.enableDepthTest();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        ResourceLocation resourcelocation = this.selected ? (this.isHovered() ? CHECKBOX_SELECTED_HOVERED_SPRITE : CHECKBOX_SELECTED_SPRITE) : (this.isHovered() ? CHECKBOX_HOVERED_SPRITE : CHECKBOX_SPRITE);
        graphics.blit(resourcelocation, this.getX(), this.getY(), 0.0f, 0.0f, 14, 14, 14, 14);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.isMouseOver(x, y)) {
            graphics.renderTooltip(Minecraft.getInstance().font, this.getMessage(), x, y);
        }
    }
}

