/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.client;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.block.TrophyBlock;
import com.gizmo.trophies.block.entity.TrophyBlockEntity;
import com.gizmo.trophies.client.ClientEvents;
import com.gizmo.trophies.client.EntityCache;
import com.gizmo.trophies.client.PlayerInfoHolder;
import com.gizmo.trophies.client.PlayerTrophyModel;
import com.gizmo.trophies.trophy.Trophy;
import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TrophyRenderer
implements BlockEntityRenderer<TrophyBlockEntity> {
    private static final List<ResourceLocation> KEYS = new ArrayList<ResourceLocation>();
    private final PlayerTrophyModel trophy;
    private final PlayerTrophyModel slimTrophy;

    public TrophyRenderer(BlockEntityRendererProvider.Context context) {
        this.trophy = new PlayerTrophyModel(context.bakeLayer(ClientEvents.PLAYER_TROPHY), false);
        this.slimTrophy = new PlayerTrophyModel(context.bakeLayer(ClientEvents.SLIM_PLAYER_TROPHY), true);
    }

    public static void renderEntity(@Nullable TrophyBlockEntity be, CompoundTag variant, String name, Level level, BlockPos pos, Trophy trophy, PoseStack stack, MultiBufferSource source, int light, boolean cycling, PlayerTrophyModel normalTrophy, PlayerTrophyModel slimTrophy) {
        stack.pushPose();
        if (KEYS.isEmpty() && !Trophy.getTrophies().isEmpty()) {
            KEYS.addAll(Trophy.getTrophies().keySet().stream().filter(location -> !location.equals((Object)BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.PLAYER))).toList());
            Collections.shuffle(KEYS);
        }
        if (trophy.type() == EntityType.PLAYER) {
            stack.translate(0.5f, 0.0f, 0.5f);
            if (be != null) {
                stack.mulPose(Axis.YP.rotationDegrees(-((Direction)be.getBlockState().getValue((Property)TrophyBlock.FACING)).toYRot()));
            }
            if (name.equalsIgnoreCase("dinnerbone") || name.equalsIgnoreCase("grumm")) {
                stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            } else {
                stack.translate(0.0f, 1.3f, 0.0f);
            }
            stack.scale(0.7f, -0.7f, -0.7f);
            PlayerInfoHolder holder = PlayerInfoHolder.getSkinFromName(name.toLowerCase(Locale.ROOT));
            if (holder.slim()) {
                slimTrophy.renderToBuffer(stack, source.getBuffer(holder.type()), light, OverlayTexture.NO_OVERLAY);
            } else {
                normalTrophy.renderToBuffer(stack, source.getBuffer(holder.type()), light, OverlayTexture.NO_OVERLAY);
            }
            if (holder.cape() != null) {
                stack.pushPose();
                stack.translate(0.0f, 0.75f, 0.06f);
                stack.scale(0.6f, 0.6f, 0.6f);
                stack.mulPose(Axis.YP.rotationDegrees(180.0f));
                normalTrophy.renderCloak(stack, source.getBuffer(RenderType.entitySolid((ResourceLocation)holder.cape())), light, OverlayTexture.NO_OVERLAY);
                stack.popPose();
            }
            if (name.equalsIgnoreCase("deadmau5")) {
                for (int j = 0; j < 2; ++j) {
                    stack.pushPose();
                    stack.translate(0.275f * (float)(j * 2 - 1), 0.0f, 0.0f);
                    stack.translate(0.0f, 0.475f, 0.0f);
                    normalTrophy.renderEars(stack, source.getBuffer(holder.type()), light, OverlayTexture.NO_OVERLAY);
                    stack.popPose();
                }
            }
        } else {
            LivingEntity entity;
            if (cycling && !KEYS.isEmpty()) {
                trophy = Trophy.getTrophies().get(KEYS.get((int)(Blaze3D.getTime() % (double)KEYS.size())));
            }
            if ((entity = EntityCache.fetchEntity(trophy.type(), level, variant, trophy.defaultData())) != null) {
                EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
                boolean hitboxes = dispatcher.shouldRenderHitBoxes();
                dispatcher.setRenderShadow(false);
                dispatcher.setRenderHitBoxes(false);
                entity.setCustomName((Component)(!name.isEmpty() ? Component.literal((String)name) : null));
                entity.setCustomNameVisible(false);
                entity.tickCount = entity instanceof Sheep && entity.hasCustomName() ? (int)level.getLevelData().getGameTime() : 0;
                entity.setPos((double)pos.getX() + 0.5 + trophy.offset().x(), (double)pos.getY() + 0.25 + trophy.offset().y(), (double)pos.getZ() + 0.5 + trophy.offset().z());
                stack.translate(0.5 + trophy.offset().x(), 0.25 + trophy.offset().y(), 0.5 + trophy.offset().z());
                if (be != null) {
                    if (LocalDate.of(LocalDate.now().getYear(), 4, 1).equals(LocalDate.now())) {
                        RandomSource rand = RandomSource.create((long)pos.asLong());
                        if (rand.nextInt(10) == 0) {
                            if (Minecraft.getInstance().cameraEntity != null) {
                                Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
                                Vec3 vec3 = new Vec3(camera.getPosition().x(), camera.getPosition().y(), camera.getPosition().z());
                                Vec3 vec31 = new Vec3((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.0f), (double)((float)pos.getZ() + 0.5f));
                                Vec3 vec32 = vec3.subtract(vec31);
                                vec32 = vec32.normalize();
                                float f5 = (float)Math.acos(vec32.y());
                                float f6 = (float)Math.atan2(vec32.z(), vec32.x());
                                stack.mulPose(Axis.YP.rotationDegrees((1.5707964f - f6) * 57.295776f));
                                stack.mulPose(Axis.XP.rotationDegrees(f5 * 57.295776f - 90.0f));
                            }
                        } else {
                            stack.mulPose(Axis.YP.rotationDegrees((float)level.getGameTime() * 15.0f));
                        }
                    } else {
                        stack.mulPose(Axis.YP.rotationDegrees(-((Direction)be.getBlockState().getValue((Property)TrophyBlock.FACING)).toYRot()));
                    }
                }
                if (trophy.type() == EntityType.FOX && name.equalsIgnoreCase("neoforge")) {
                    stack.mulPose(Axis.YP.rotationDegrees((float)level.getGameTime() * 15.0f));
                }
                stack.mulPose(Axis.XP.rotationDegrees((float)trophy.rotation().x()));
                stack.mulPose(Axis.YP.rotationDegrees((float)trophy.rotation().y()));
                stack.mulPose(Axis.ZP.rotationDegrees((float)trophy.rotation().z()));
                stack.scale(0.4f, 0.4f, 0.4f);
                stack.scale(trophy.scale(), trophy.scale(), trophy.scale());
                try {
                    dispatcher.render((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, stack, source, light);
                }
                catch (Exception e) {
                    OpenBlocksTrophies.LOGGER.error("Failed to render entity {} as a trophy", (Object)trophy.type().getDescriptionId(), (Object)e);
                    EntityCache.addEntityToBlacklist(trophy.type());
                }
                dispatcher.setRenderShadow(true);
                dispatcher.setRenderHitBoxes(hitboxes);
            }
        }
        stack.popPose();
    }

    public void render(TrophyBlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource source, int light, int overlay) {
        if (blockEntity.getTrophy() != null) {
            stack.pushPose();
            if (!((Boolean)blockEntity.getBlockState().getValue((Property)TrophyBlock.PEDESTAL)).booleanValue()) {
                stack.translate(0.0, -0.25, 0.0);
            }
            TrophyRenderer.renderEntity(blockEntity, blockEntity.getVariant(), blockEntity.getTrophyName(), blockEntity.getLevel(), blockEntity.getBlockPos(), blockEntity.getTrophy(), stack, source, light, blockEntity.isCycling(), this.trophy, this.slimTrophy);
            stack.popPose();
        }
    }
}

