/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.client;

import com.gizmo.trophies.client.ClientEvents;
import com.gizmo.trophies.client.DisplayTrophyRenderer;
import com.gizmo.trophies.client.PlayerTrophyModel;
import com.gizmo.trophies.client.TrophyRenderer;
import com.gizmo.trophies.item.DisplayTrophyItem;
import com.gizmo.trophies.item.TrophyItem;
import com.gizmo.trophies.misc.TrophyRegistries;
import com.gizmo.trophies.trophy.DisplayTrophy;
import com.gizmo.trophies.trophy.Trophy;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class TrophyItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private PlayerTrophyModel trophy = new PlayerTrophyModel(Minecraft.getInstance().getEntityModels().bakeLayer(ClientEvents.PLAYER_TROPHY), false);
    private PlayerTrophyModel slimTrophy = new PlayerTrophyModel(Minecraft.getInstance().getEntityModels().bakeLayer(ClientEvents.SLIM_PLAYER_TROPHY), true);

    public TrophyItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void onResourceManagerReload(ResourceManager manager) {
        super.onResourceManagerReload(manager);
        this.trophy = new PlayerTrophyModel(Minecraft.getInstance().getEntityModels().bakeLayer(ClientEvents.PLAYER_TROPHY), false);
        this.slimTrophy = new PlayerTrophyModel(Minecraft.getInstance().getEntityModels().bakeLayer(ClientEvents.SLIM_PLAYER_TROPHY), true);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext context, PoseStack ms, MultiBufferSource source, int light, int overlay) {
        Item item = stack.getItem();
        if (item instanceof TrophyItem) {
            Trophy trophy;
            BakedModel base = Minecraft.getInstance().getBlockRenderer().getBlockModel(((Block)TrophyRegistries.TROPHY.get()).defaultBlockState());
            Minecraft.getInstance().getItemRenderer().renderModelLists(base, stack, light, overlay, ms, source.getBuffer(RenderType.solid()));
            if (stack.has(TrophyRegistries.TROPHY_INFO) && (trophy = TrophyItem.getTrophy(stack)) != null && Minecraft.getInstance().level != null) {
                TrophyRenderer.renderEntity(null, TrophyItem.getTrophyVariant(stack), stack.has(DataComponents.CUSTOM_NAME) ? stack.getHoverName().getString() : "", (Level)Minecraft.getInstance().level, BlockPos.ZERO, trophy, ms, source, light, TrophyItem.hasCycleOnTrophy(stack), this.trophy, this.slimTrophy);
            }
        } else if (item instanceof DisplayTrophyItem) {
            BakedModel base = Minecraft.getInstance().getBlockRenderer().getBlockModel(((Block)TrophyRegistries.TROPHY.get()).defaultBlockState());
            Minecraft.getInstance().getItemRenderer().renderModelLists(base, stack, light, overlay, ms, source.getBuffer(RenderType.solid()));
            if (stack.has(TrophyRegistries.DISPLAY_TROPHY_INFO)) {
                DisplayTrophy trophy = DisplayTrophyItem.getTrophy(stack);
                if (trophy != null) {
                    ms.pushPose();
                    ms.translate(0.5f, 0.5f, 0.5f);
                    ms.mulPose(Axis.YP.rotationDegrees(180.0f));
                    DisplayTrophyRenderer.renderDisplay(trophy.displayItem(), trophy.scale(), trophy.offset(), trophy.rotation(), 0.0f, false, 0.0f, ms, source, light, overlay);
                    ms.popPose();
                }
            } else {
                ms.pushPose();
                ms.translate(0.5f, 1.05f, 0.5f);
                ms.mulPose(Axis.YP.rotationDegrees(135.0f));
                ms.scale(-0.1f, -0.1f, 0.1f);
                Minecraft.getInstance().font.drawInBatch("?", -2.5f, 0.0f, -1, false, ms.last().pose(), source, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                ms.mulPose(Axis.YP.rotationDegrees(180.0f));
                Minecraft.getInstance().font.drawInBatch("?", -2.5f, 0.0f, -1, false, ms.last().pose(), source, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                ms.popPose();
            }
        }
    }
}

