/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.client;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public record PlayerInfoHolder(RenderType type, @Nullable ResourceLocation cape, boolean slim) {
    private static final Map<String, GameProfile> GAMEPROFILE_CACHE = new HashMap<String, GameProfile>();
    public static final List<String> TF_DEVS = List.of("benimatic", "drullkus", "tamaized", "jodlodi", "alphaleaf", "killer_demon", "gizmothemoonpig");
    public static final List<String> MOJANGSTAS = new ArrayList<String>();

    public static PlayerInfoHolder getSkinFromName(String name) {
        RenderType type = RenderType.entityCutoutNoCullZOffset((ResourceLocation)DefaultPlayerSkin.getDefaultTexture());
        ResourceLocation cape = null;
        boolean slim = true;
        try {
            if (name.length() > 2 && !name.contains(" ")) {
                SkinManager manager;
                PlayerSkin skin;
                GameProfile gameprofile1;
                GameProfile profile = null;
                if (GAMEPROFILE_CACHE.containsKey(name)) {
                    profile = GAMEPROFILE_CACHE.get(name);
                }
                if (profile == null && !StringUtils.isBlank((CharSequence)(gameprofile1 = new GameProfile(Util.NIL_UUID, name)).getName())) {
                    SkullBlockEntity.fetchGameProfile((String)gameprofile1.getName()).thenAcceptAsync(newProfile -> newProfile.ifPresent(gameProfile -> GAMEPROFILE_CACHE.put(gameProfile.getName().toLowerCase(), (GameProfile)gameProfile)));
                }
                if (profile != null && (skin = (PlayerSkin)(manager = Minecraft.getInstance().getSkinManager()).getOrLoad(profile).getNow(null)) != null) {
                    type = RenderType.entityTranslucent((ResourceLocation)skin.texture());
                    slim = skin.model().equals((Object)PlayerSkin.Model.SLIM);
                    if (skin.capeTexture() != null && ((cape = skin.capeTexture()).getPath().equals("capes/ea963f1b7d7c510da28800a770882d0c4b0aee6d") || cape.getPath().equals("capes/b5fa1ffb0f5b47d0803ca98b3759f12d5910760e") || cape.getPath().equals("capes/71716f0d5ebbc0b24f957d38cfc593906a3cdadf")) && !MOJANGSTAS.contains(name)) {
                        MOJANGSTAS.add(name);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new PlayerInfoHolder(type, cape, slim);
    }
}

