/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.client;

import com.gizmo.trophies.OpenBlocksTrophies;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EntityCache {
    private static final Map<EntityType<?>, Entity> ENTITY_MAP = new WeakHashMap();
    private static final Set<EntityType<?>> IGNORED_ENTITIES = new HashSet();

    @Nullable
    public static LivingEntity fetchEntity(EntityType<?> type, @Nullable Level level, CompoundTag variant, Optional<CompoundTag> defaultVariant) {
        if (level != null && !IGNORED_ENTITIES.contains(type)) {
            LocalPlayer entity = null;
            if (type == EntityType.PLAYER) {
                entity = Minecraft.getInstance().player;
            } else {
                try {
                    entity = ENTITY_MAP.computeIfAbsent(type, t -> {
                        Entity created = t.create(level);
                        if (created != null) {
                            created.setYRot(0.0f);
                            created.setYHeadRot(0.0f);
                            created.setYBodyRot(0.0f);
                            created.hasImpulse = false;
                            if (created instanceof Mob) {
                                Mob mob = (Mob)created;
                                mob.setNoAi(true);
                            }
                        }
                        return created;
                    });
                }
                catch (Exception e) {
                    OpenBlocksTrophies.LOGGER.error("Failed to cache a render for entity {}", (Object)type.getDescriptionId(), (Object)e);
                }
            }
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                CompoundTag tag = new CompoundTag();
                defaultVariant.ifPresent(tag1 -> tag1.getAllKeys().forEach(s -> tag.put(s, Objects.requireNonNull(tag1.get(s)))));
                if (!variant.isEmpty()) {
                    if (entity instanceof VillagerDataHolder) {
                        VillagerDataHolder villager = (VillagerDataHolder)entity;
                        variant.getAllKeys().forEach(s -> villager.setVillagerData(new VillagerData(VillagerType.PLAINS, Objects.requireNonNull((VillagerProfession)Minecraft.getInstance().level.registryAccess().registryOrThrow(Registries.VILLAGER_PROFESSION).get(ResourceLocation.tryParse((String)variant.getString(s)))), 1)));
                    } else {
                        variant.getAllKeys().forEach(s -> tag.put(s, Objects.requireNonNull(variant.get(s))));
                    }
                }
                if (!tag.isEmpty()) {
                    living.readAdditionalSaveData(tag);
                    if (entity instanceof Mob) {
                        Mob mob = (Mob)entity;
                        mob.setNoAi(true);
                    }
                }
                return living;
            }
            IGNORED_ENTITIES.add(type);
            ENTITY_MAP.remove(type);
        }
        return null;
    }

    public static void addEntityToBlacklist(EntityType<?> type) {
        IGNORED_ENTITIES.add(type);
        ENTITY_MAP.remove(type);
    }
}

